<?php   
class searchArticles
{
	public function strip_word_html($text, $allowed_tags = '<b><i><sup><sub><em><strong><u><br><a>') 
    {
    	mb_regex_encoding('UTF-8'); 
        //replace MS special characters first 
        $search = array('/&lsquo;/u', '/&rsquo;/u', '/&ldquo;/u', '/&rdquo;/u', '/&mdash;/u', '/&quot;/u', '/&acute;/u', '/&ndash;/u', '/&acirc;/u', '/&frasl;/u', '/&reg;/u', '/&uacute;/u', '/&eacute;/u', '/&acute;/u', '/&acirc;/u', '/&oacute;/u', '/&beta;/u', '/&alpha;/u', '/&atilde;/u', '/&mu;/u', '/&pi;/u', '/&Omega;/u', '/&deg;/u', '/&infin;/u', '/&trade;/u', '/&plusmn;/u', '/&auml;/u', '/&euml;/u', '/&uuml;/u', '/&yuml;/u'); 
        $replace = array('\'', '\'', '\"', '\"', '\-', '\"', "\'", '\�', '\ ', '\/', '\�', '\�', '\�', '\�', '\�', '\�', '\�', '\a', '\�', '\�', '\p', '\?', '\�', '\8', '\�', '\�', '\�', '\�', '\�', '\�'); 
        $text = preg_replace($search, $replace, $text); 
        //make sure _all_ html entities are converted to the plain ascii equivalents - it appears 
        //in some MS headers, some html entities are encoded and some aren't 
        $text = html_entity_decode($text, ENT_QUOTES, 'UTF-8'); 
        //try to strip out any C style comments first, since these, embedded in html comments, seem to 
        //prevent strip_tags from removing html comments (MS Word introduced combination) 
        //if(mb_stripos($text, '/*') !== FALSE){ 
         //   $text = mb_eregi_replace('#/\*.*?\*/#s', '', $text, 'm'); 
        //} 
        //introduce a space into any arithmetic expressions that could be caught by strip_tags so that they won't be 
        //'<1' becomes '< 1'(note: somewhat application specific) 
        $text = preg_replace(array('/<([0-9]+)/'), array('< $1'), $text); 
        $text = strip_tags($text, $allowed_tags); 
        //eliminate extraneous whitespace from start and end of line, or anywhere there are two or more spaces, convert it to one 
        $text = preg_replace(array('/^\s\s+/', '/\s\s+$/', '/\s\s+/u'), array('', '', ' '), $text); 
        //strip out inline css and simplify style tags 
        $search = array('#<(strong|b)[^>]*>(.*?)</(strong|b)>#isu', '#<(em|i)[^>]*>(.*?)</(em|i)>#isu', '#<u[^>]*>(.*?)</u>#isu'); 
        $replace = array('<b>$2</b>', '<i>$2</i>', '<u>$1</u>'); 
        $text = preg_replace($search, $replace, $text); 
        //on some of the ?newer MS Word exports, where you get conditionals of the form 'if gte mso 9', etc., it appears 
        //that whatever is in one of the html comments prevents strip_tags from eradicating the html comment that contains 
        //some MS Style Definitions - this last bit gets rid of any leftover comments */ 
        $num_matches = preg_match_all("/\<!--/u", $text, $matches); 
        if($num_matches)
		{
		$text = preg_replace('/\<!--(.)*--\>/isu', '', 
		$text); 
        } 
        return $text; 
    }
	private function getCategory($cid)
	{
	$sql="select category_name from category_master where category_name=$cid";
	$dbq = query($sql);
	if(getRowCount($dbq) >=1)
	{
	while($records = fetch($dbq))
	{
	return $records['category_name'];
	}		
	}
	return "";
	}
	public function showArchives()
	{
		$sql = "SELECT * FROM issue_master where issue_status='Visible' order by issue_id desc";
		$dbq = query ($sql);
		assert ($dbq);
		echo '<table width="100%" border="0" cellspacing="0" cellpadding="0">';
		$i=1;$bgcolour="";
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
			if ($bgcolour == "row_line2")
				$bgcolour = "row_line1";
			else
				$bgcolour = "row_line2";
				echo "<tr><td width=\"100%\" class=$bgcolour onmouseout=\"className='$bgcolour';\" style='font-size: 12px;    line-height: 18px;'>J.App.Pharm.Sci. ".$records['issue_no'].", <a href=\"past-articles.php?issueid=".$records['issue_id']."\">".$records['issue_period']."</a></td></tr>";
			}
		}
     	echo "</table>";
	}
	
	public function getCurrentIssueTitle()
	{
		$sql = "select * from issue_master where issue_status='Current'";
		$dbq = query ($sql);
		//assert ($dbq);
		$i=1;
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
				echo trim($records['issue_no']) . ", " . trim($records['issue_period']);
				break;
			}
		}
	}
	public function getEditorContents($id)
	{
		$sql = "select contents from editor_master where editor_id=$id";
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;
		if( getRowCount($dbq) >=1)
		{
		while($records = fetch($dbq))
		{ 
			echo html_entity_decode($records['contents']);
			break;
			}
		}
	}
	public function getEditorContentsterms($id)
	{
		$sql = "select contents from editor_master where editor_id=$id";
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;
		if( getRowCount($dbq) >=1)
		{
		while($records = fetch($dbq))
		{ 
			echo html_entity_decode(strip_tags($records['contents']));
			break;
			}
		}
	}
	
	public function getAboutJournal()
	{
		$sql = "select contents from about_journal";
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
				echo $records['contents'];
				break;
			}
		}
	}
	
	public function getIndexingname()
	{
		$sql = "select * from indexing_master where index_sts='Visible' order by index_sort";
		$dbq = query ($sql);
		assert ($dbq);
		if(getRowCount($dbq) >=1)
		{
			$storearray = array();
			$count=0;
			while($records = mysql_fetch_array($dbq, MYSQL_ASSOC))
			{ 
				$storearray[$count] = $records['index_name'];
				//$index = explode(',',$storearray);
				$count++;
			}
			$index_val = implode(", ", $storearray);
			print_r($index_val);
		}
	}
	
	public function getCurrentIssuePeriod()
	{
		$sql = "select * from issue_master where issue_status='Current'";
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;	
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
				echo "<span style=\"text-transfrom:uppercase;\">".trim($records['issue_period'])."</span>";
				break;
			}
		}
	}

	public function updateCounter($id)
	{
		$sql = "select view from articles where article_id=".$id;
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;	
		if(getRowCount($dbq) >=1)
		{
			/*$records = fetch($dbq);
				$count=$records[0]+1;
				$sqlarti="update articles set view=".$count." where article_id=".$id;
				query ($sqlarti);
			*/
			$records = fetch($dbq);
			$text="Event Time [".date('d-m-Y h:i:s')."] Update article [id=".$id." from view count =".$records[0]." to view count =".($records[0]+1)."]\n";
			$filenameSuccess='log/log'.date('d-m-Y');
			$fp = fopen($filenameSuccess, "a+");
			$fw = fwrite($fp,$text);
			fclose($fp);
			$count=$records[0]+1;
			$sql1="update articles set view=".$count." where article_id=".$id;
			query($sql1);
		}
	}
	public function updateDownloadCounter($id)
	{
		$sql = "select download from articles where article_id=".$id;
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;	
		if( getRowCount($dbq) >=1)
		{
			$records = fetch($dbq);
			$text="Event Time [".date('d-m-Y h:i:s')."] Download article [id=".$id." from download count =".$records[0]." to download count =".($records[0]+1)."]\n";
			$filenameSuccess='log/log'.date('d-m-Y');
			$fp = fopen($filenameSuccess, "a+");
			$fw = fwrite($fp,$text);
			fclose($fp);
			$count=$records[0]+1;
			$sql1="update articles set download=".$count." where article_id=".$id;
			query ($sql1);
		}
	}

	
	public function getArchiveIssueTitle()
	{
		$issueid	= isset ($_REQUEST['issueid']) ? $_REQUEST['issueid'] : '';
		$sql = "select * from issue_master where issue_id=$issueid";
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
				echo trim($records['issue_no']) . ", " . trim($records['issue_period']);
				break;
			}
		}
	}

	private function getIssueUrl($issueid)
	{
		$issue_url = "";
		$sql = "select issue_url from issue_master where issue_id=$issueid";
		$dbq = query ($sql);
		assert ($dbq);
		if( getRowCount($dbq) >=1)
		{
			$records = fetch($dbq);
			$issue_url = trim($records['issue_url']);
		}
		return $issue_url;
	}
		
	public function archiveIssueArticle()
	{
		$issueid	= isset ($_REQUEST['issueid']) ? $_REQUEST['issueid'] : '';
		//$issue_url	= $this->getIssueUrl($issueid);
		$cat1_total = 0;
		$cat2_total = 0;
		
		$sql = "select *, file_url as filelink from articles where articles.issue_id=$issueid ";//and article_category='" . $this->tabname[0] . "'";
		$cat1_data = $this->makeDataGrid($sql,"search",$cat1_total,0);
		
		?>
                    <div id="Pha" style="background-color:#F5F7F0; width: 200px;"><?php  echo $cat1_data; ?></div>
	<?php 
	    	
	}
	
	
	
	public function arcIssueArticle()
	{
		$cat1_total = 0;
		$issueid	= isset ($_REQUEST['issueid']) ? $_REQUEST['issueid'] : '';		
		$sql = "select *,file_url as filelink from articles where issue_id = $issueid order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		
		$cat1_data = $this->makeDataGrid($sql,"normal",$cat1_total,0);
		?>
		<div id="tabs" style="border:0;">
	    <?php
		
					echo '<div id="Pha" style="">';                 	
        				echo $cat1_data;						
					echo '</div>';
	    		?>
                
				</div>
                
<?php                 
	} 
	
	public function abstractdetails()
	{     
     	$cat1_total = 0;
		 $article_id	= isset ($_REQUEST['article_id']) ? $_REQUEST['article_id'] : '';
		
						
		$sql = "SELECT  * FROM articles a join issue_master i where a.issue_id=i.issue_id  and article_id = $article_id order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
	

		//$sql = "SELECT * FROM articles a join issue_master i where a.issue_id=i.issue_id and $condition order by article_id $desc LIMIT 1";
		$cat1_data = $this->viewAbstract($sql,"normal",$cat1_total);
				echo $cat1_data;					
		?>
<?php
	}
	public function abstractdetails_old()
	{     
     	$cat1_total = 0;
     	
     		     	
		$article_id	= isset ($_REQUEST['article_id']) ? $_REQUEST['article_id'] : '';		
				
		$sql = "SELECT * FROM articles a join issue_master i where a.issue_id=i.issue_id and article_id = $article_id order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		
		$cat1_data = $this->viewAbstract($sql,"normal",$cat1_total);
				
		?>
		<div>
	    	<ul>
	    		<li></li>		
	    	</ul>
		<?php
		
						echo $cat1_data;						
				?>
                
				</div>
                <?php
				}
	
	public function getMostViewArticle()
	{
		$cat1_total = 0;
		$view	= isset ($_REQUEST['view']) ? $_REQUEST['view'] : '';		
		//$sql = "select *,file_url as filelink from articles order by view desc limit 5";
		$sql = "SELECT *, file_url as filelink, view+download+(SELECT SUM(View)+sum(Download) FROM ViewDownload vd WHERE vd.Article_id = articles.article_id)  as total FROM articles order by total desc limit 5";
		
		$cat1_data = $this->fillMostView($sql,"normal",$cat1_total);
		
		?>
		<div id="tabs" style="border:0;">
	    <?php
			echo '<div id="Pha" style="">';              	
        		echo $cat1_data;						
			echo '</div>';
	    ?>
        </div>
        <?php
		
	}
	
	public function getNews()
	{
		$cat1_total = 0;
		$news_sts	= isset ($_REQUEST['news_sts']) ? $_REQUEST['news_sts'] : '';		
		$sql = "select * from news_master where news_sts='Visible' order by news_sort asc";
		
		$cat1_data = $this->fillNewsGrid($sql,"normal",$cat1_total);
		
			//echo '<div id="Pha" style="background-color:#F5F7F0;">';
			echo '<div id="Pha">';                 	
        		echo $cat1_data;						
			echo '</div>';
	   
	}
	
	public function currentIssueArticle()
	{
		$cat1_total = 0;
	   //$sql = "select *,a.file_url as filelink,b.issue_no from articles a, issue_master b where a.issue_id = b.issue_id and b.issue_status='Current' order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		$sql="select * from articles a, issue_master b where a.issue_id=b.issue_id and b.issue_status = 'Current'";
		$cat1_data = $this->makeDataGrid($sql,"normal",$cat1_total,0);
?>
		<div id="tabs" style="border:0;">
	   <?php
			echo '<div id="Pha">';
			echo $cat1_data;
			echo '</div>';
		?>
                
		</div>             
                
				<?php
				if($cat1_total<=0 && $cat2_total<=0)
				{
				?>		
<?php 
				}
	}
	public function MostviewedArticle()
	{
		$cat1_total = 0;
		
	$sql= "SELECT *, file_url as filelink, view+download+(SELECT SUM(View)+sum(Download) FROM ViewDownload vd WHERE vd.Article_id = articles.article_id)  as total FROM articles order by total desc limit 15";
		
	//$sql="select *, file_url as filelink,(view+download) as total from articles  ORDER BY total DESC limit 15";
		
	//$sql="SELECT  `article_id` , `article_category`, `title`, `authors` , `file_url` as filelink , `pages` , `keywords`, `issue_id`, `view`, `download`, `doi`, `long_desc`, `doiurl`, `reference`, `fulltexts`, `article_cite`, `cover_page`, `publish_date`, `affilation_symbol`, `description`, `Reviewed` , (view+download) as total    FROM `articles`    order by total DESC limit 15";
		
		$cat1_data = $this->makeDataGrid($sql,"normal",$cat1_total,1);
		?>
		<div id="tabs">
	   <?php 
		echo '<div id="Pha" style="">';
        	echo $cat1_data;
		echo '</div>';
	
	?>
	
				</div>
				<?php
				if($cat1_total<=0 && $cat2_total<=0)
				{
				?>		
				
<?php 
				///**for new records in VIewDownload tables added by surbhi**///
	
       /*  $sql0 = "SELECT  Article_id,SUM(View) as total  FROM  ViewDownload  group by Article_id order by total  desc limit 5";		
		$dbq = query($sql0);
		if(getRowCount($dbq) >=1)
		{
		while($records = fetch($dbq))
		{
		$article_id= $records['Article_id'];
		$sql = "select *,file_url as filelink from articles where article_id=".$article_id."";
		$cat1_data = $this->fillMostView($sql,"normal",$cat1_total);
		?>
		<div id="tabs" style="border:0;">
	    <?php
			    echo '<div id="Pha" style="">';              	
        		echo $cat1_data;
				
				echo '</div>';
	    ?>
        </div>
        <?php
		
		}
		}
		
	////** END Codefor new records in VIewDownload tables**///
		}
	}


  	public function searchIssueArticle()
  	{
		$cat1_total = 0;
		$cat2_total = 0;
		$cat3_total = 0;
		$cat4_total = 0;
  		$record = array();
 		$record['au']	= isset ($_REQUEST['au']) ? $_REQUEST['au'] : '';
		$record['tit']	= isset ($_REQUEST['tit']) ? $_REQUEST['tit'] : '';
		$record['ky']	= isset ($_REQUEST['ky']) ? $_REQUEST['ky'] : '';		
		$record['isu']	= isset ($_REQUEST['isu']) ? $_REQUEST['isu'] : '';
		$record['cat']	= isset ($_REQUEST['cat']) ? $_REQUEST['cat'] : '';
		
		if($record['au']!="" || $record['tit']!="" || $record['ky']!=""|| $record['isu']!="" || $record['cat']!="")
		{
			$sql = "select a.*,sm.issue_no,a.file_url as filelink from articles a, issue_master sm where a.issue_id=sm.issue_id";
			
			if($record['au']!="")
			{
				$sql .= " and authors like '%".$record['au']."%'";
			}
			if($record['tit']!="")
			{
				$sql .= " and title like '%".$record['tit']."%'";
			}
			if($record['ky']!="")
			{
				$sql .= " and keywords like '%".$record['ky']."%'";
			}
			if($record['isu']!="" && $record['isu']!="0")
			{
				$sql .= " and sm.issue_id like '%".$record['isu']."%'";
			}
			if($record['cat']!="" && $record['cat']!="0")
			{
				$sql .= " and a.article_category like '%".$record['cat']."%'";
			}
			//echo $this->makeDataGrid($sql,"search");
		}		
		//$cat1_data = $this->makeDataGrid($sql,"search",$cat1_total);
		
		$sql1=$sql;
		$sql4=$sql;
		$sql3=$sql;
		
		
		//echo $sql = "select a.*,replace(a.file_url,'[URL]',b.issue_url) as filelink from articles a, issue_master b where a.issue_id = b.issue_id and b.issue_status='Current' and article_category='" . $this->tabname[0] . "'";
		$sql .= " and a.article_category='" . $this->tabname[0] . "'  and a.article_subcategory='" . $this->subtabname[0] . "' order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		$cat1_data = $this->makeDataGrid($sql,"search",$cat1_total,0);
		
		$sql1 .= " and a.article_category='" . $this->tabname[0] . "'   and a.article_subcategory='" . $this->subtabname[1] . "' order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		$cat2_data = $this->makeDataGrid($sql1,"search",$cat2_total,0);
		
		
		$sql3 .= " and a.article_category='" . $this->tabname[1] . "'   and a.article_subcategory='" . $this->subtabname[0] . "' order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		$cat3_data = $this->makeDataGrid($sql3,"search",$cat3_total,0);
		
		
		$sql4 .= " and a.article_category='" . $this->tabname[1] . "'   and a.article_subcategory='" . $this->subtabname[1] . "' order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		$cat4_data = $this->makeDataGrid($sql4,"search",$cat4_total,0);
		
		?>
		<div id="tabs" style="border:0;">
	    	<ul>
	    		<?php
	    			if ($cat1_total >=1 || $cat2_total >=1)
	    			{
	    				?>
	    					<li><a href="#Pha"><span><?php  echo $this->tabname[0]; ?></span></a></li>		
	    				<?php 
	    			}
	    			
					if ($cat3_total >=1 || $cat4_total >=1)
	    			{
	    				?>
	    					<li><a href="#Bio"><span><?php  echo $this->tabname[1]; ?></span></a></li>		
	    				<?php 
	    			}
	    		?>
	    	</ul>
		<?php
		
				if ($cat1_total >=1 || $cat2_total >=1)
	    		{
	    				    
					echo '<div id="Pha" style="">';
                 	if($cat1_total>=1)  
					{
        				echo '<span class="toplink"><h3>'. $this->subtabname[0].'</h3></span>'.$cat1_data;
					}
					if($cat2_total>=1)  
					{ 
        				echo '<span class="toplink"><h3>'. $this->subtabname[1].'</h3></span>'.$cat2_data;
					}
					echo '</div>';
	    		}
	    		
				
				if ($cat3_total >=1 || $cat4_total >=1)
	    		{
	    				    
					echo '<div id="Bio" style="background-color:#F5F7F0;">';
                 	if($cat3_total>=1)  
					{ 
        				echo '<span class="toplink"><h3>'. $this->subtabname[0].'</h3></span>'.$cat3_data;
					}
					if($cat4_total>=1)  
					{ 
        				echo '<span class="toplink"><h3>'. $this->subtabname[1].'</h3></span>'.$cat4_data;
					}
					echo '</div>';
	    		}
	}

	private function makeDataGrid($sql,$action="normal",&$total_record=0, $mv=0)	//$action = normal/search
	{
		$dbq = query ($sql);
		assert ($dbq);
		$i		= 0;
		$data 	= "";
		$colnum = 3;
		$data.= "<table border =\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"10\" style='font-size: 12px; line-height: 18px;'>";
		if( getRowCount($dbq) >=1)
		{
			$data .= "<tr style=\"background: #fff;border-top: 1px solid #ccc;\"></tr>";
			while($records = fetch($dbq))
			{   
				$authors = stripslashes(str_replace(",",", ",$records['authors']));
				$articleid = $records['article_id'];
				$i++;
				$data .= "<tr>";
				$DbContent = self::strip_word_html(html_entity_decode($records['title'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><ul><ol><li><br>');
				//$DbContent=$records['title'];
				//$DbContent=htmlentities($DbContent,ENT_COMPAT,'utf-8'); 
	      		//$DbContent = html_entity_decode($DbContent,ENT_COMPAT,'ISO-8859-1'); 
	      		//$DbContent = self::unhtmlspecialchars($DbContent);
	      		
				$DbContent1 = self::strip_word_html(html_entity_decode($authors,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><ul><ol><li><br>');
				$DbContent1 = preg_replace("/<sup>(.*?)<\/sup>/i","",$DbContent1);
				//$DbContent=$records['title'];
				//$DbContent1=htmlentities($DbContent1,ENT_COMPAT,'utf-8'); 
	      		//$DbContent1 = html_entity_decode($DbContent1,ENT_COMPAT,'ISO-8859-1'); 
	      		//$DbContent1 = self::unhtmlspecialchars($DbContent1);
				
				
				$style= "";
				$style2= "";
			/* 	if($records['cover_page']!='')
				{
				$style= "style='padding-left:12px;'";
				$style3= "style='border: #CCC 1px solid;cursor: pointer; opacity: 1;'";
				$style2= "style='padding-left:13px;'";
	      		$data .="<td rowspan=\"2\"  style='margin:8px; width:16%; vertical-align: top;  '  >
				<div style='height:100px; width:100px; padding:0px; margin:4px; position: relative; vertical-align: top; '>
				<div style=' position: absolute; right:-3px; bottom:0px;'>
			    <img src='cms/php/images/stock-vector-set-magnifying-glass-zoom-icons-569064451.jpg' width='15px;' height='15px;'/>
				</div>
				<img src='cms/php/images/"."min".$records['cover_page']."' width='102px;' height='98px;' class='image_zoom'  ".$style3."  /> 
				</div>
				</td>";
				}
				 */
				$data .= "<td colspan=\"3\" ".$style."><span class=\"title\"><strong>".$records['article_category'].": </strong>" .$DbContent/*htmlspecialchars_decode($DbContent, ENT_NOQUOTES)*//*self::strip_word_html(, $allowed_tags = '<b><i><sup><sub><em><strong><u><br>')*/. "</span><p class=\"author\" style=\"margin:0; padding:2px 0;\"> ".$DbContent1." </p><p style=\"margin:0; padding:2px 0;\">";
        if($records['doi']!='')
	  	{
			 if ($records['doiurl']!='')
				 {
				  if(strstr($records['doiurl'],'http://'))
				  {
				    $data .= "<strong>DOI:</strong>: "."<a href=".$records['doiurl']." target =\" \">".$records['doi']."</a>&nbsp;&nbsp;&nbsp;&nbsp;";      
				  }else
				  {
				  $data .= "<strong>DOI:</strong> "."<a href=http://".$records['doiurl']." target =\" \">".$records['doi']."</a>&nbsp;&nbsp;&nbsp;&nbsp;";
				  }
				  }else
				  {
				  $data .= "<strong>DOI:</strong> ".$records['doi']."</a>&nbsp;&nbsp;&nbsp;&nbsp;";
                  }
				
		} 
	  	else 
	  	{
	  		//$data .= "<p style=\"margin:0; padding:2px 0;\">Pages: ".$records['pages']."</p>";
	  	}
		$data .= "Pages: ".$records['pages']."</p>";
			$data .="</td></tr><tr>";
			if($records['cover_page']!=''){
			// $data .="<td></td>";
			}
			
			for($l=0; $l<$articleid; $l++){
			$month=date("m");
		    $year = date('Y'); 
		      //$sql = "select * from ViewDownload where Article_id= $id and MONTH(dated) = '$month' and YEAR(dated) = '$year'";
		    $sql6 = "select Article_id,dated,year(dated) as y, month(dated) as m,SUM(View) as tview,SUM(Download) as tdownload from ViewDownload where  Article_id = '".$articleid."'  group by year(dated)";
			  $dbq6 = query ($sql6);
			  // assert ($dbq);
			  $i=0;
			  $data2  = array();		
			  $res2   = array();		
			  if($dbq6)
				{
				  while($row6 = fetch($dbq6)) 
					{
					   // $data1['Article_id'] = $row5['Article_id'];
					   // $time1 = $row5['Dated'];
					   $time2 = $row6['dated'];
					   $Download= $row6['tdownload'];
					   $data2['monthName']=date("F",strtotime($time2));
					   //$data2['yearname']=date("Y",strtotime($time2));
					   $data2['yearname']=$row6['y'];
					   $data2['Download21'] = $row6['tdownload'];
					   $data2['View21']=$row6['tview'];
				       $data2['View'] = $row6['tview'];
					   $view21=$data2['View'];
					   $Download21= $data2['Download21'];
					   $total2=$view21+$Download21;
					   $res2[] = $data2;
					
					}
				}
		   }
			 $data2 = json_encode($res2);
			 
			 $viewtt=$view21+$records['view'];
		//	while($records1 = fetch($dbq1))
			//{  
			 $Downloadt=$Download21+$records['download'];
			 $totaltt=$viewtt+$Downloadt;
			
			
		if($mv)
		{
			$data .= "<td  colspan=\"2\" ".$style2." >[<a href=\"javascript:void(0);\" onclick=\"window.open('counter.php?aid=".$records['article_id']."','_self')\" >Abstract</a>]&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  [<a href=\"admin/php/uploads/".$records['filelink']."\" onclick=\"window.open('counter.php?did=".$records['article_id']."','_parent')\" target=\"_blank\">Full Text PDF</a>] </td>";
			$data .= "<td colspan=\"3\" style=\"text-align:right;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<i>Abstract Views:&nbsp;&nbsp;".$viewtt."</i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Downloaded:&nbsp;&nbsp;".$Downloadt."</i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<i>Total Views:&nbsp;&nbsp;".$totaltt."</i></td>";
			
		}
		else {
			
			$data .= "<td colspan=\"2\" ".$style2." ><p style=\"margin:0; padding:13px 0;\">[<a href=\"javascript:void(0);\" onclick=\"window.open('counter.php?aid=".$records['article_id']."','_self')\">Abstract</a>]&nbsp;&nbsp;&nbsp; ";
			
			if($records['fulltexts']!=''){
			$data .= "[<a style='font-size: 12px;' href=\"javascript:void(0);\" onclick=\"window.open('counter.php?fid=".$records['article_id']."','_parent')\" target=\"_blank\">Full Text HTML</a>]&nbsp;&nbsp;&nbsp;&nbsp;";
			}
			
			$data .= "[<a style='font-size:12px;' href=\"admin/php/uploads/".$records['filelink']."\" onclick=\"window.open('counter.php?did=".$records['article_id']."','_parent')\" target=\"_blank\">Full Text PDF</a>]&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[<a style='font-size:12px;' href=\"downloadxml.php?article_id=".$records['article_id']."\">XML: Abstract + References</a>]</p></td>";		
		}
      			$data .="</tr>";
				$data .= "<tr style=\"background: #fff;border-top: 1px solid #ccc;\"></tr><tr><td colspan=\"4\"><hr></td></tr>";				
			}	
			
		}
		
	//	}
		else
		{
		$data .= "";			
		}		
     	$data .= "</table>";     	
     	$total_record = $i;
     	return $data;
	}
	
	
	
	private function fillMostView($sql,$action="normal",&$total_record=0)	//$action = normal/search
	{
		$dbq = query ($sql);
		assert ($dbq);
		
		$i		= 0;
		$data 	= "";
		$colnum = 3;
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
				$str = self::strip_word_html($records['title'], $allowed_tags = '<b><i><sup><sub><em><strong><u><br>');
				/*if(strlen($str)>90)
				{
					$str=substr($str,0,90);					
				}href=\"abstract.php?article_id=".$records['article_id']."&sts=2\"
				$str=$str." <span style=\"color:#0b75b2\">read more</span>";*/
				$data .= "<li><p><a style=' cursor: pointer; 'onclick=\"window.open('counter.php?aid=".$records['article_id']."','_self')\">" .$str. "</a></p></li><br/>";
			}
		}
     	$total_record = $i;
     	return $data;
	}
	private function fillNewsGrid($sql,$action="normal",&$total_record=0)	//$action = normal/search
	{
		$dbq = query ($sql);
		assert ($dbq);
		
		$i		= 1;
		$data 	= "";
		$colnum = 3;
		if( getRowCount($dbq) >=1)
		{
			$data.="<ul>";
			while($records = fetch($dbq))
			{ $i++;
				$data .= "<li>";
				$data .= stripslashes(self::strip_word_html($records['news_desc'], $allowed_tags = '<b><i><sup><sub><em><strong><u><br><a>')). "</li>";
			}
						$data.="</ul>";
			
		}
     	$total_record = $i;
     	return $data;
	}
	private function fillNewsGridold($sql,$action="normal",&$total_record=0)	//$action = normal/search
	{
		$dbq = query ($sql);
		assert ($dbq);
		
		$i		= 1;
		$data 	= "";
		$colnum = 3;
		if( getRowCount($dbq) >=1)
		{
		while($records = fetch($dbq))
		{ 
		$data_pdf="";
		
		if($records['file'] != ""){
		   $data_pdf = "href='cms/php/announcement_pdf_image/".$records['file']."'";
		   $data .= "<p style='text-align:justify;'><a ".$data_pdf.">&bull;";
		   $data .= " ".stripslashes(self::strip_word_html(html_entity_decode($records['news_desc'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><ul><ol><li><br><a>')). "</a></p>";
		 }else if($records['link'] != ""){
			$data_pdf = "href='".$records['link']."'";
			$data .= "<p style='text-align:justify;'>&bull;<a ".$data_pdf.">";
				$data .= " ".stripslashes(self::strip_word_html(html_entity_decode($records['news_desc'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><ul><ol><li><br><a>')). "</a></p>";
		 }else{
			    $data.= "<p style='text-align:justify;'>&bull;";
				$data .= " ".stripslashes(self::strip_word_html(html_entity_decode($records['news_desc'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><ul><ol><li><br><a>')). "</p>";
		}
		// $data .= "<p><a ".$data_pdf.">".$i++;
		// $data .= ". ".stripslashes(self::strip_word_html(html_entity_decode($records['news_desc'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><ul><ol><li><br>')). "</a></p><br />";
			}
		}
     	$total_record = $i;
     	return $data;
	}


	private function viewAbstract($sql,$action="normal",&$total_record=0)	//$action = normal/search
	{
		$dbq = query ($sql);
		assert ($dbq);
		
		$i		= 0;
		$data 	= "";
		$colnum = 3;
		
		$data.= "<table border =0 width=100% align=left cellspacing=0 cellpadding=10 class='viewAbstract_data' >";
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
		
				$authors = str_replace(",",", ",$records['authors']);
				$keywords = str_replace(",",", ",$records['keywords']);
				$reference = $records['reference'];
				$reference = str_replace("&nbsp;", '', $reference);
				$affilation_symbol = $records['affilation_symbol'];
				
				$article_cite =$records['article_cite'];
				$article_cite = self::strip_word_html(html_entity_decode($article_cite,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sub><em><strong><u><br><p> <a><ul><ol><li><br>');
				//$description = $records['description'];
	            // $description=strip_tags($description);
				
				//$description = self::strip_word_html(html_entity_decode($records['description'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><ul><ol><li><br>');
				//$description = str_replace( "\n", '<br/>',$records['description']);
				///$description = nl2br($records['description']);
				//$description= str_replace("\n","",$records['description']);
				$description = preg_replace('/(\r\n|\r)/', '<br/>',$records['description']);
				$description = self::strip_word_html(html_entity_decode($description,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><ul><ol><li><p>');
				
				 $DbContent = self::strip_word_html(html_entity_decode($records['title'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><ul><ol><li><br>');
				 $DbContent =preg_replace('/ {2,}/', ' ', str_replace('&nbsp;', ' ', $DbContent));
				
				
				//$DbContent = html_entity_decode($records['title']);
				
				
				//$DbContent=$records['title'];
				//$DbContent=htmlentities($DbContent,ENT_COMPAT,'utf-8'); 
	      		//$DbContent = html_entity_decode($DbContent,ENT_COMPAT,'ISO-8859-1'); 
	      		//$DbContent = self::unhtmlspecialchars($DbContent);
	      		
				// $DbContent1 = self::strip_word_html(html_entity_decode($records['long_desc'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><p><a><ul><ol><li><br>');
			   
			   $DbContent1 = html_entity_decode($records['long_desc'],ENT_COMPAT, "UTF-8");
			   $DbContent1 = str_replace("&nbsp;", ' ', strip_tags($DbContent1 , $allowed_tags = '<b><i><sup><sub><em><strong><u><br><p><a><ul><ol><li><br>'));
			   $fulltext = html_entity_decode($records['fulltexts'],ENT_COMPAT, "UTF-8");
			   $fulltext = str_replace("&nbsp;", ' ', $fulltext);
			   
			  //$DbContent1 = str_replace("<em>", ' ', $DbContent1);
			  //$DbContent1 = str_replace("</em>", ' ', $DbContent1);
				
				$str = "";
				$str1 = "";
				$Article_Authors = self::strip_word_html(html_entity_decode($authors,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sub><em><strong><u><br><p><a><ul><ol><li><br>');
				
				$Authors1 = self::strip_word_html(html_entity_decode($authors,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><p><a><ul><ol><li><br>');
				
				$Article_Authors1 = explode(",",$Authors1);
				//$Article_Authors = count($Article_Authors);color:#1e9a9e;
				for($i =0; $i<count($Article_Authors1); $i++)
				{
				  $aut =  $Article_Authors1[$i];
				  $str.="<a class='georgia' style='color:#1a96bc;' href='author_article.php?author=".$Article_Authors1[$i]."' class='georgia' style='color:#1e9a9e;' >".$aut."</a>,";
				}
				$str =  rtrim($str,",");
				$Article_Auth = $str;
				
				
				$Article_Keywords = self::strip_word_html(html_entity_decode($keywords,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sub><em><strong><u><br><p> <a><ul><ol><li><br>');
				
				
				$Article_Keywords1 = explode(",",$Article_Keywords);
				//$Article_Authors = count($Article_Authors);
				for($j =0; $j<count($Article_Keywords1); $j++){
				  $str1.="<a class='georgia' style='/*color:#666;*/' href='keyword_article.php?keyword=".strip_tags($Article_Keywords1[$j])."' class='Aut_Key_style' >".$Article_Keywords1[$j]."</a>,";
				  /// This code for similar article (start)///
				  $keyword = strip_tags($Article_Keywords1[$j]);
				  $sql123 = "select * from articles where keywords LIKE '%".$keyword."%' and article_id<>'".$records['article_id']."'";
				  $dbq123 = query ($sql123);
					if($records123 = fetch($dbq123))
					{
                     $str123.=$records123['article_id'].",";					
					}
				/// This code for similar article (end)///	
				}
				$str1 =  rtrim($str1,",");
				$Article_Keywords = $str1;
				/// This code for similar article (start)///
				$str123 =  rtrim($str123,",");
				$similar_article_id = $str123;
				$similar_article_id = explode(',', $similar_article_id);
                $similar_article_id = array_unique($similar_article_id);
				/// This code for similar article (end)///
				
				
				// $DbContent1 = self::strip_word_html($records['long_desc'], $allowed_tags = '<b><i><sup><sub><em><strong><u><br><p><a><ul><ol><li><br>');
				
	      		// $DbContent1 = self::strip_word_html(html_entity_decode($records['long_desc'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><a><ul><li>');
				//$DbContent=$records['title'];
				//$DbContent1=htmlentities($DbContent1,ENT_COMPAT,'utf-8'); 
	          	//	$DbContent1 = html_entity_decode($DbContent1,ENT_COMPAT,'ISO-8859-1'); 
	         	//	$DbContent1 = self::unhtmlspecialchars($DbContent1);
				$i++;
				$data .= "<tr><td>";
				$data .= "<div><p style='display:inline-block;font-size:12px !important;'>Home >";
				if ($records['issue_status']=='Current')
				{
				$data .= "<a href=\"current.php\">Current Issue</a></p>";
				}
				else if($records['issue_status']=='Visible')
				{
				$data .= "<a href=\"past_issue.php\">Archive</a></p>";
				}else{
					$data .= "<a href=\"past_issue.php\">Online First</a></p>";
				}
				
		
				
				$originaldate= str_replace(', ' , '-', $records['issue_period']);
				$date = date_create_from_format('M-Y', $originaldate);
                $date=date_format($date, '01-m-Y');
				
		 	 if(strtotime($date)  >= strtotime('01-07-2017')){
					$data.='<!-- Start CrossMark Snippet v1.5 --> 
					
					<div style="float:right"><script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.4.4/jquery.min.js" ></script> 
					<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.7/jquery-ui.min.js" ></script> 
					<script type="text/javascript" src="https://crossmark.crossref.org/javascripts/v1.5/crossmark.min.js"></script> 
					<a id="open-crossmark" href="#" style="padding: 3px 0 13px 0;"><img style="border: 0; display: none;" id="crossmark-icon" src="https://crossmark.crossref.org/images/crossmark_button.png" /></a> 
					</div> 
					<div id="crossmark-dialog" style="display:none;" title=""> 
						<!-- the external CrossMark data is loaded inside this iframe --> 
						<iframe id="crossmark-dialog-frame" frameborder="0"></iframe> 
					</div> 
					</div>
					<div style="clear:both;"></div>
					<div >
					
		        <!-- End CrossMark Snippet -->';
				
				}
				 if ($records['issue_no']!='')
				{
				$data .= "<p style='font-size:12px ;line-height: 1.5;' >".$records['issue_no'].", ".$records['issue_period']."<br>";
				}
			 if ($records['doi']!='')
				{	 
			 if ($records['doiurl']!='')
				 {
				  if(strstr($records['doiurl'],'http://'))
				  {
				    $data .= "".$records['issue_period']."<p style='padding-top:12px;'><strong style='font-size:12px;' >DOI:</strong> "."<a href=".$records['doiurl']." target =\" \">".$records['doi']."</p></a>";      
				  }else
				  {
				  $data.= "<strong style='font-size:12px;' >DOI:</strong> "."<a href=http://".$records['doiurl']." target =\" \">".$records['doi']."</a>";
				  }
				 }else
				 {
				  $data .= "<strong style='font-size:12px;' >DOI:</strong> ".$records['doi']."";

				 }
				}
					$link='#';
					if($records['file_url']!='')
					{
						$link="admin/php/uploads/".$records['file_url'];
					}
					////////cross mark code///////////
					
					// $data .= "</p>
				 // <h1>".self::getCategory($records['article_category'])."</h1>
				 // <h2 class='txt-size'>".$DbContent."</h2>
				 // <p>".self::strip_word_html(html_entity_decode($authors,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><p><a><ul><ol><li><br>')."</p>";
				 
				 $data .= "</p><br><br>
				<h1 style='color:gray;font-size:17px !important;'>".$records['article_category']."</h1>
				 <h2 class='txt-size' style='padding:10px 10px 10px 0px;'>".$DbContent."</h2>
				 <p class=''>".$Article_Auth." 
                 </p>";
				 //$data .= "<p>[<a href=\"$link\" onclick=\"window.open('counter.php?did=".$records['article_id']."','_parent')\" target=\"_blank\">Download PDF</a>]</p>";style='display:none;'
				 ////////////////// THIS CODE IS FOR TOGGLE AUTHOR AFFILIATIONS////////////////class=\"btn btn-info\"onclick=\"opend();\"
				
				 //$data .= "<a href='#showdiv1' class='clicker' tabindex='1' id=\"def\"   ><i class='fa fa-plus-square-o' ></i> Author Affiliations </a>";
			     $data .= "<a  href='javascript:void(0);' class=\"btn btn-info\"onclick=\"opend();\" id=\"def\"><i id='showm2' class='fa fa-plus-square-o '></i><i id='showm1' class='fa fa-minus-square-o hidden' ></i>&nbsp; Author Affiliations </a>";
				 $data .= "<div id='showdiv1' style='display:none;font-size:12px !important;line-height:1.1' >";
				// $arr=self::getaffilationauthor();
				 
				// for($i=0;$i<count($arr);$i++)
				// {
					$data .= " <p style='font-size:12px !important;'>".$description." 
                 </p>";
				 // $data .= "<p class=''>".$description." 
               //  </p>";
					// $data .=$arr[$i]['symbol']." - ".$arr[$i]['desc']."<br> ";
				//}
				
				 $data .="</div>";
				
				 ////////////////LINKS FOR TABS LIKE ABSTRACT, REFERANCES....ETC///////////
			$data .=" <br/><br/><div >
            <a class=\"tablinks\" href='javascript:void(0);'onclick=\"openCity(event, 'abstract')\" id=\"defaultOpen\"><span style=\"color: #ad5123;\">Abstract</span></a> ";
			if($fulltext !="")
					{
			 $data .=" | <a class=\"tablinks\" onclick=\"openCity(event, 'fulltextse')\"  href='javascript:void(0);' id=\"defaultOpenfull\"><span style=\"color: #ad5123;\">Full-text (HTML) </span></a>";
					}

					$data .=" |
					 <a class=\"tablinks\" onclick=\"openCity(event, 'reference')\"  href='javascript:void(0);'><span style=\"color: #ad5123;\">References</span></a> |
					  <a class=\"tablinks\" onclick=\"openCity(event, 'Article_metries')\"  href='javascript:void(0);'href='javascript:void(0);'><span style=\"color: #ad5123;\">Article Metrics</span></a> |
					  <a class=\"tablinks\" onclick=\"openCity(event, 'Similar_Articles')\"  href='javascript:void(0);'><span style=\"color: #ad5123;\">Similar Articles</span></a> 
					
					  <!--<button class=\"tablinks\" onclick=\"openCity(event, 'Tokyo')\"><b style=\"color: #0196e3;\">Tokyo</b></button>-->
					 </div>

					<hr/><div id=\"abstract\" class=\"tabcontent\" style='font-family: MuseoSans-300, sans-serif;
					font-style: normal;
					font-weight: 300; font-size:13px; line-height:22px;  ' ";
					if (strlen($DbContent1) >1){
					$data .= "<p class=\"abstract txt-size\" style='margin-bottom:0px;  text-align: justify;'><h4 style='margin-bottom:0px;'><b>Abstract</b></h4><span style='text-align: justify;'><p>".$DbContent1."</p></span></p>";
                    $data .= "<table>
					<tr>
					<td valign=\"top\"><strong style='font-family: MuseoSans-300, sans-serif;
                     font-style: normal;
                    font-weight: 300; margin-left:-5px;font-size:13px; line-height:22px;'><b>Keywords:</b></strong></td>
					<td valign='top' style='font-family: MuseoSans-300, sans-serif;
                    font-style: normal;
                    font-weight: 300; font-size:13px; line-height:22px;' ><a> ".$Article_Keywords."</a></td>
					</tr>
					
					</table>
					<br/>
					 <hr/>";
			$data .= "<div id=\"bottom1\" style='font-family: MuseoSans-300, sans-serif;
                         font-style: normal;
                         font-weight: 300; font-size:13px; line-height:22px;'>
						 <b style='font-size: 13px;'>
						 Citation:</b> ";
						 $data.=self::strip_word_html(html_entity_decode($article_cite,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><ul><li>');
						$data .="</br>";
						$data .="</br>";
                         if($records['Reviewed'] != ""){
                         $data.= "<b>Reviewed by: </b>";
                         $data.= html_entity_decode($records['Reviewed']);
                            }
                      /* Khatri DK, Tiwari DN, Bariya HS. Chitinolytic efficacy and secretion of cell wall-degrading enzymes from Trichoderma spp. in response to phytopathological fungi. J App Biol Biotech. 2017;5(6):1-8. DOI: 10.7324/JABB.2017.50601.<br/><br/>"; if($records['Copyright'] != ""){
                       $data.= "Copyright";
                       $data.= html_entity_decode($records['Copyright']);
                           } */
                        $data.= "";
	                    $data.= "</div>";				
					 }
					 //$match_date = date('d.m.Y H:i', strtotime($records['publish_date']));
                     //$year = explode("-", $records['publish_date']);
					$pubdates=strtotime($records['publish_date']);
					
					 if($pubdates < strtotime('2017-07-19')){
					  $data .= "</br><div  style='font-family: MuseoSans-300, sans-serif;
                         font-style: normal;
                         font-weight: 300; font-size:13px; line-height:22px;'><span style='font-size: 13px;'><b>Copyright: </b>The Author(s). This is an open access article distributed under the <a href='https://creativecommons.org/licenses/by/3.0/' target='_blank'> Creative Commons Attribution Non-Commercial License,</a> which permits unrestricted use, distribution, and reproduction in any medium, provided the original work is properly cited.</span></div>";
					  $data .= "</div>";
					 }else{
					  $data .= "</br><div  style='font-family: MuseoSans-300, sans-serif;
                         font-style: normal;
                         font-weight: 300; font-size:13px; line-height:22px;'><span style='font-size: 13px;'><b>Copyright: </b>The Author(s). This is an open access article distributed under the <a href='https://creativecommons.org/licenses/by/4.0/' target='_blank'> Creative Commons Attribution Non-Commercial License,</a> which permits unrestricted use, distribution, and reproduction in any medium, provided the original work is properly cited.</span></div>";
					  $data .= "</div>";
					 }
					  $data .= "<div id=\"reference\" class=\"tabcontent\" style='font-family: MuseoSans-300, sans-serif; font-style: normal;font-weight: 300; font-size:13px; line-height:22px;word-wrap: break-word;'><h1 class='txt-size'><b style='font-size: 15px;'>References</b></h1>";
					  $data.= self::strip_word_html(html_entity_decode($reference,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><p><a><ul><ol><li><br>');
					  $data .= "</div>";
					  $data .= "<div id=\"fulltextse\" class=\"tabcontent\" style='font-family: MuseoSans-300, sans-serif; font-style: normal;font-weight: 300; font-size:13px; line-height:22px; word-wrap: break-word;'>";
					  //<h1 class='txt-size'><b style='font-size: 15px;'></b></h1>--> ";
					  $exp = html_entity_decode($records["fulltexts"]);
                      //$fulltext = html_entity_decode($records["imagestext"]);
					//  echo $exp;
					$first = explode("<img", $exp);
					  $var ="";
						$va ="";
						for($i=0; $i<count($first); $i++){
							
							$var.=$first[$i];
						}
							$second =str_replace("/", " ", $var);
							$third = explode(" ", $second);
					 // $data. =  $match;
					 // $data.= self::strip_word_html(html_entity_decode($fulltext,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><p><a><ul><ol><li><br>');
					   $last="";
						for($i=0; $i<count($third); $i++){
						//$last.= $third[$i]; 							
						if( $third[$i] == "images")
						 $last.= $third[$i+1];
					 }	
						$fourth=explode('"',$last);
					//	print_r($fourth);
					
					   $lastno=count($fourth);
					
						for($i=0; $i<count($fourth); $i++){
					         if($i<$lastno-1){
							$data .= "<div class='filename'><a style='position:relative; left:200px;   href='#'><span style='display:none'>/</span></a><span style='display:none;' class='ckeditorimages'>".$fourth[$i]."</span></div>";
						   if($i==0){
							}
							 else{
							 }
							 }
						}
						$data .=   "<span style='position:relative; margin-bottom:300px;' href='#'>".$fulltext."</span>";
				      //echo $records["fulltexts"];
					  //$data .=   print_r(explode("=", $records["fulltexts"]));
					  $data .= "</div>";
					  $data .= "
					  <div id=\"Article_metries\" class=\"tabcontent\" style='font-family: MuseoSans-300, sans-serif; font-style: normal;font-weight: 300; font-size:13px; line-height:22px; word-wrap: break-word;'> <h1 style='margin-bottom:0px;font-size:15px; display:none;'><b>Article Metrics</b></h1>";
					  $data.= "<div class='sidebar' style='position: relative; left:65px;'>
					  <span style='font-family:Helvetica;font-size:20px;color:black;align:center;'>Article Metrics</span>";
					   
           // $sql = "SELECT count(article_id) as id_count,c.category_name FROM `ViewDownload` a INNER JOIN category_master c ON a.article_category=c.category_id where c.org_id=".ORG_ID." and a.issue_id!=0 group by article_category";
		  // $sql = "SELECT *  FROM `ViewDownload`";
		   $article_id1 = $records['article_id'];
		   //for old data 
		   for($l=0; $l<$article_id1; $l++){
		   $sql5 = "select download,view  from articles where  article_id = '".$article_id1."' ";
			 $dbq55 = query($sql5);
			 // assert ($dbq);
			 $i=0;
			 $data3 = array();		
			 $res1 = array();		
			 if($dbq55)
				{
				  while($row5 = fetch($dbq55)) 
					{
					 //$data1['Article_id'] = $row5['Article_id'];
					 //$time1 = $row5['Dated'];
				     $data3['download'] = $row5['download'];
					 $data3['view']  = $row5['view'];
					 $viewo          = $data3['view'];
					 $Downloado      = $data3['download'];
				     $total          = $data3['view'] + $data3['download'];
					 $res3[]         = $data3;
					 }
				}
		   }
		   $data3 = json_encode($res3);
			 
		   
		   
		   for($l=0; $l<$article_id1; $l++){
		   $sql5 = "select Dated,Download,View  from ViewDownload where  Article_id = '".$article_id1."' order by Dated desc";
			$dbq55 = query ($sql5);
			// assert ($dbq);
			 $i=0;
			 $data1 = array();		
			 $res1 = array();		
			 if($dbq55)
				{
				  while($row5 = fetch($dbq55)) 
					
					{
					   // $data1['Article_id'] = $row5['Article_id'];
					   // $time1 = $row5['Dated'];
					   $time1             = $row5['Dated'];
					   $Download          = $row5['Download'];
					   $data1['monthName']= date("F",strtotime($time1));
					   $data1['yearname'] = date("Y",strtotime($time1));
					   $data1['Download'] = $row5['Download'];
					   $data1['View']     = $row5['View'];
				       $data1['View']     = $row5['View'];
					   $view1             = $data1['View'];
					   $Download          = $data1['Download'];
					   $total             = $view1+$Download;
					   $res1[]            = $data1;
					 }
				}
		   }
		      $data1 = json_encode($res1);
			 
			  $data .= " <table style='width:100%;' style='backgraund-color:white;'>";
			  $article_id2 = $records['article_id'];
		      for($l=0; $l<$article_id2; $l++){
			  $month=date("m");
		      $year = date('Y'); 
		      //$sql = "select * from ViewDownload where Article_id= $id and MONTH(dated) = '$month' and YEAR(dated) = '$year'";
		    $sql6 = "select Article_id,dated,year(dated) as y, month(dated) as m,SUM(View) as tview,SUM(Download) as tdownload from ViewDownload where  Article_id = '".$article_id2."'  group by year(dated)";
			  $dbq6 = query ($sql6);
			  // assert ($dbq);
			  $i=0;
			  $data2  = array();		
			  $res2   = array();		
			  if($dbq6)
				{
				  while($row6 = fetch($dbq6)) 
					{
					   // $data1['Article_id'] = $row5['Article_id'];
					   // $time1 = $row5['Dated'];
					   $time2 = $row6['dated'];
					   $Download= $row6['tdownload'];
					   $data2['monthName']=date("F",strtotime($time2));
					   //$data2['yearname']=date("Y",strtotime($time2));
					   $data2['yearname']=$row6['y'];
					   $data2['Download21'] = $row6['tdownload'];
					   $data2['View21']=$row6['tview'];
				       $data2['View'] = $row6['tview'];
					   $view21=$data2['View'];
					   $Download21= $data2['Download21'];
					   $total2=$view21+$Download21;
					   $res2[] = $data2;
					
					}
				}
		   }
			 $data2 = json_encode($res2);
			 
			 $viewtt=$view21+$viewo;
			 $Downloadt=$Download21+$Downloado;
			 $totaltt=$viewtt+$Downloadt;
			/*  $data .= "<tr style='backgraund-color:white;' >
             <td style='backgraund-color:white;'><span style='text-align: center; font-size:17px;background-color:white;color:black;'>Abstract Views:<br><br>
			 <span style='font-size:35px;text-align: center;' >&nbsp;&nbsp;&nbsp;&nbsp;".$view21."</span></span></td>
			 <td class='vl'></td>
			 <td align:'center;' style='font-size:15px;'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Downloads:</td>
             <td  style='backgraund-color:white;'><span style='text-align:center;font-size:17px;background-color:white;color:black;'>Pdf Downloads:<br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style='font-size:35px;'>".$Download21."</span></span></br></br>
			 <div class='text-right'style='text-align: right;'><span class='fa fa-circle' style='color:#689e96;'> Abstract</span>
			 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <span class='fa fa-circle' style='color:#0a2110'> Pdf Download</span></div></td>
			
         </tr>"; */
		
		 // $data .= "<div>PDF:</div>";//<span>PDF:</span> </th>
		
          /*  $data .= "<tr>
           <td style='text-align: center;font-size:17px;'><b>".$total."</b></td>
         
           <td style='text-align: center;font-size:17px;'><b>".$Download."</b></td>
		   
		   <td class='vl' style='backgraund-color:white;'><span style='text-align:center;font-size:17px;background-color:white;color:black;'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pdf Downloads:<br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Downloads: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style='font-size:35px;'>".$Download."</span></span></td>
		   
  </tr>"; */
			 
			  //$data .= "</table>";
			  
			 
			/* $data .= " <table style='width:100%'>";
			  $data .= "<tr>";
			  $data .= " <td>";
			 $data .= "<label id='chart'style='text-align: center; font-size:15px;color:black;' > <b>HTML Views.</b> </label><sup><span style='font-size:19px;color:#42a0f7;' class='fa fa-info-circle tooltip tooltiptext' ><span class='tooltiptext' style='font-family:Arial;font-size:13px;' >Total number of HTML pages view for this article.These views are recordede directly within the system itself. overall monthly view count also be available.</span></span></sup>";
			 $data .= "</br>";
			  $data .= "</br>";
			  
			  $data .= "<div id='chart1' class='text-center' style='background: #c8d7d7;
            -moz-border-radius: 5px; -webkit-border-radius: 5px;border-radius: 5px;color: #304345;
            text-align: center;height:70px; width:120px; font-size:15px;color:black;' ><br> ".$view1." <br>  This Journal</div>";
			 */
           //$data .= "</div>";style='height:200px; width:250px;  // var earlyAttendance1  = JSON.parse(earlyAttendance1);Verdana,Arial,Helvetica,sans-serifstyle='float: right;'
			 // if($data1 != ""){
				// $data .= "</td>";
			//$data .= "<td>";
			// $data .= "<div id='chartContainer2' style='height: 200px; width: 100%; '></div> ";
			  
			  
			  
		   
			 $data .= "<script style='display:none;'> 
			 
			 var dataPointsabstactm = [];
			 var View1;
             var View1  = ".$data1.";
	         document.write('');
			 for(var i=0; i<View1.length; i++){
		     dataPointsabstactm.push({label: View1[i].monthName,
			 y:  parseInt(View1[i].View)});
			 
			
	}     
	</script >";
	
	 $data .= "<script> 
			 var dataPointsabstacty = [];
			  var View2;
			 
             var View2  = ".$data2.";
		     document.write('');
			 for(var i=0; i<View1.length; i++){
		     dataPointsabstacty.push({label: View2[i].yearname,
			 y:  parseInt(View2[i].View21)});
			 
	}     
	</script>";
	//$data .= "</td>";
	// $data .= "</tr>";
	//$data .= "</table>";
	        $data .= " <table style='width:30%;'>";
	        $data .= "<tr>";
			$data .="</br><div class='pull-right'style='text-align: left; position:relative; right:97px;' bottom: 120px;> <span class='fa fa-circle' style='color:#6f96a8;'>Abstract</span>&nbsp;&nbsp;&nbsp;
			  <span class='fa fa-circle' style='color:#0a2b3a;text-align: left;'> Pdf Download</span></div>";
			  $data .= "<td></br>";
			  
			 //  $data .= "<label id='chart11' style='text-align: left;font-size:17px;color:black;' >Total Views</label> <sup><span style='font-size:19px;color:#42a0f7;' class='fa fa-info-circle tooltip tooltiptext' ><span class='tooltiptext' style='font-family:Arial;font-size:13px;' >Total number of Views for this article.These views are recorded directly within the system itself. overall monthly view count also be available.</span></span></sup>";
			//$data .= "</br> ";
			
			$data .= "<div id='chart15' class='text-center' style='background: #96c8e4;
            -moz-border-radius: 5px; -webkit-border-radius: 5px;border-radius: 5px;color: #304345;
            text-align: center;height:70px; width:120px;color:black;font-size:15px;'><br><b>Total    Views</b><br> ".$totaltt." <br></div>";
			$data .= "</br>";
			 
			  // $data .= "<label id='chart11' style='text-align: left;font-size:17px;color:black;' >Article Metrix.</label> <sup><span style='font-size:19px;color:#42a0f7;' class='fa fa-info-circle tooltip tooltiptext' ><span class='tooltiptext' style='font-family:Arial;font-size:13px;' >Total number of abstract views for this article.These views are recorded directly within the system itself. overall monthly view count also be available.</span></span></sup>";
			  
			 $data .= "<div id='chart15' class='text-center' style='background: #96c8e4;
            -moz-border-radius: 5px; -webkit-border-radius: 5px;border-radius: 5px;color: #304345;
            text-align: center;height:70px; width:120px;color:black;font-size:15px;'  ><br><b>Abstract views</b><br> ".$viewtt." <br></div>";
			  $data .= "</br>";
			  
			// $data .= "<label id='chart11' style='text-align: left;font-size:17px;color:black;' >Pdf Downloads.</label> <sup><span style='font-size:19px;color:#42a0f7;' class='fa fa-info-circle tooltip tooltiptext' ><span class='tooltiptext' style='font-family:Arial;font-size:13px;' >Total number of PDF Download for this article.These views are recorded directly within the system itself. overall monthly view count also be available.</span></span></sup>#c8d7d7";
			
			 $data .= "<div id='chart15' class='text-center' style='background: #96c8e4;
            -moz-border-radius: 5px; -webkit-border-radius: 5px;border-radius: 5px;color: #304345;
            text-align: center;height:70px; width:120px;color:black;font-size:15px;' ><br><b>Pdf Downloads</b><br> ".$Downloadt." <br> </div>";
			
			  $data .= "</td>";
			  
			  $data .= "<td>";
			 
			 $data .= "<div id='chartContainer3' style='height: 200px; width:100%; '></div> ";
			 
			 $data .= "<script> 
			 var dataPointspdfm = [];
             var download1  = ".$data1.";
	          document.write('   ');
			
	         for(var i=0; i<download1.length; i++){
		     dataPointspdfm.push({label: download1[i].monthName, y:  parseInt(download1[i].Download) });
			 
	}     
	</script>";
	 $data .= "<script style='color:white;'>
			 var dataPointspdfy = [];
			  var download2;
			   
             var download2  = ".$data2.";
			  document.write('   ');
	         for(var i=0; i<download1.length; i++){
				 
				 
		     dataPointspdfy.push({ label: download2[i].yearname, y:  parseInt(download2[i].Download21) });
			 
	}     
	</script>";
	
	$data .= "</td>";
	$data .= "</tr>";
    $data .= "</table>";
	$data .= "</br>";
	$data .= "</br>";
	$data .= "</br>";
	
	
	/*  $data .= "<script>   document.write(download1['Download']);document.write('      ');
			  var chart1 = new CanvasJS.Chart('chartContainer2', {
	animationEnabled: true,
	
	data: [{
		type: 'bar',
		startAngle: 240,
	
		indexLabel: '{label} {y}',
		dataPoints: dataPoints16
	}]
});
chart1.render();</script>"; */
			 // }else{
             //  echo '<marquee height="136" direction="up" scrollamount="1" onmouseover="this.stop()" onmouseout="this.start()"><p>Coming Soon...</p></marquee>';
			 
			 // } 
			  
			   $data .= "</div>";
			   
			  $data .= "</div>";
                      /*  for($l=0; $l<count($similar_article_id); $l++){
						    $sql1234 = "select * from articles where  article_id = '".$similar_article_id[$l]."'";
				            $dbq1234 = query ($sql1234);
							if($records1234 = fetch($dbq1234))
							{
								$DbContent1234 = self::strip_word_html(html_entity_decode($records1234['title'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><ul><ol><li><br>');
								$DbContent12345 = self::strip_word_html(html_entity_decode($records1234['authors'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><ul><ol><li><br>');
								$DbContent12345 = preg_replace("/<sup>(.*?)<\/sup>/i","",$DbContent12345);
							 $data.="<span class='txt-size' ><a href=\"javascript:void(0);\" onclick=\"window.open('counter.php?aid=".$records1234['article_id']."','_self')\" >".$DbContent1234."</a></span><br><span class=\"author\" style=\"margin:0; padding:2px 0;\"> ".$DbContent12345." </span><br><br>";	
							 
							 
				
                              						 
							}
						 }							 
					  
                    $data .= "</div> */
					 $data .= "<div id=\"Similar_Articles\"  class=\"tabcontent\"> <h1 style='margin-bottom:0px;'><b>Similar Articles</b></h1>";
					 // $data.=
                         for($l=0; $l<count($similar_article_id); $l++){
						    $sql1234 = "select * from articles where  article_id = '".$similar_article_id[$l]."'";
				            $dbq1234 = query ($sql1234);
							if($records1234 = fetch($dbq1234))
							{
								$DbContent1234 = self::strip_word_html(html_entity_decode($records1234['title'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><ul><ol><li><br>');
								$DbContent12345 = self::strip_word_html(html_entity_decode($records1234['authors'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><ul><ol><li><br>');
								$DbContent12345 = preg_replace("/<sup>(.*?)<\/sup>/i","",$DbContent12345);
							    $data.="<span class='txt-size'><a href=\"javascript:void(0);\" onclick=\"window.open('counter.php?aid=".$records1234['article_id']."','_self')\" ><span style='font-size:12px;'>".$DbContent1234."</span></a></span><br><span class=\"author\" style=\"margin:0; padding:2px 0;font-size:12px;\"> ".$DbContent12345." </span><br><br>";	
							  						 
							}
						 }							 
					  
					
					 // print_r($similar_article_id);	
                    $data .= "<hr></div>";					  
					/* <table>
					<tr>
					<td valign=\"top\"><strong style='font-family: MuseoSans-300, sans-serif;
font-style: normal;
font-weight: 300; font-size:13px; line-height:22px;'>Keywords:</strong></td>
					<td valign='top' style='font-family: MuseoSans-300, sans-serif;
font-style: normal;
font-weight: 300; font-size:13px; line-height:22px;' > ".$Article_Keywords."</td>
					</tr>
					</table>
					<br/>
					 <hr/>"; */
					
					

				  
					  // $data .= "<h4 style=\"margin-top:30px;font-size:17px;\">Abstract</h4>
					  // <p class=\"abstract\">".$DbContent1."</p>
					  // <p><strong>Keywords:</strong> ".self::strip_word_html(html_entity_decode($keywords,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><p><a><ul><ol><li><br>')."</p>";
					  
					  
					   //$data .= "<h4 style=\"margin-top:30px;font-size:17px;\">Abstract</h4>
					  //<p class=\"abstract\">".$DbContent1."</p>
					  //<p><strong>Keywords:</strong> ".html_entity_decode($keywords)."</p>";
				  
				  
				  
				  
 					//$data.="<br/><h4>Full Text:</h4>";
 					//$data.=self::strip_word_html(html_entity_decode($article_cite,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br>');
 				  
 				  //$data.="<h4 style=\"margin-top:30px;\"><a href=\"#\" class=\"expand-content-link\" style='font-size:17px;' >References<i class=\"fa fa-caret-down\" aria-hidden=\"true\" style='float:right;font-size:20px'></i></a></h4><div class=\"hidden-content\" style='display:none;'>";
				  
				   // $data.= self::strip_word_html(html_entity_decode($reference,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><p><a><ul><ol><li><br>');
				   
				   
				   //$data.= html_entity_decode($reference);
				   
				   
				   
 				  // $data.=self::strip_word_html($reference, $allowed_tags = '<b><i><sup><sub><em><strong><u><br><p><a><ul><ol><li>');
			          //$data .= "</div>";
					  //////////////////////////////////////
			          // $data .= "<div id=\"bottom\" style='font-family: MuseoSans-300, sans-serif;
// font-style: normal;
// font-weight: 300; font-size:13px; line-height:22px;'><b style='font-size: 15px;'>Citation:</b> Khatri DK, Tiwari DN, Bariya HS. Chitinolytic efficacy and secretion of cell wall-degrading enzymes from Trichoderma spp. in response to phytopathological fungi. J App Biol Biotech. 2017;5(6):1-8. DOI: 10.7324/JABB.2017.50601.<br/><br/><p>Reviewed by:<br/>

// <b style='color:#ad5123'>Franc Llorens</b>, Centro de Investigacion Biomedica en Red
// Sobre Enfermedades Neurodegenerativas, Spain <br/>
// <b style='color:#ad5123'>Charlotte Elisabeth</b> Teunissen, VU University AAmsterdam,
// Netherlands<br/><br/>
// <b style='font-size: 15px;'>Copyright</b> ©  2017  Chitinolytic efficacy and secretion of cell wall-degrading enzymes from Trichoderma spp. in response to <b style='color:#ad5123'>Creative Commons Attribution License(CCBY).</b> efficacy and secretion of cell wall-degrading enzymes from Trichoderma spp. in response to phytopathological fungi.
// </p>";
///////////////////////

			        /*  $data .= "<div id=\"bottom\" style='font-family: MuseoSans-300, sans-serif;
font-style: normal;
font-weight: 300; font-size:13px; line-height:22px;'><b style='font-size: 15px;'>Citation:</b> Khatri DK, Tiwari DN, Bariya HS. Chitinolytic efficacy and secretion of cell wall-degrading enzymes from Trichoderma spp. in response to phytopathological fungi. J App Biol Biotech. 2017;5(6):1-8. DOI: 10.7324/JABB.2017.50601.<br/><br/>";
if($records['Reviewed'] != ""){
$data.= "Reviewed by:";
$data.= html_entity_decode($records['Reviewed']);
}
if($records['Copyright'] != ""){
$data.= "Copyright";
$data.= html_entity_decode($records['Copyright']);
}
$data.= "";
					  
					  //$data.= html_entity_decode($article_cite);
					  
					  // $data.= self::strip_word_html(html_entity_decode($article_cite,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><p><a><ul><ol><li><br>');
					  
					  
					  
					  // $data.= self::strip_word_html($article_cite, $allowed_tags = '<b><i><sup><sub><em><strong><u><br><p><a><ul><ol><li>');
					  
			          // $data.=self::strip_word_html(html_entity_decode($article_cite,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><ul><li>');
					  //$data .="fhhfhgh";
			          //$data .= "</div>";*/
			      $data .= "</div>";
				  $data .="</td></tr>";
				
			}	
		}
		else
		{
			$data .= "<tr><td colspan=5 align=center>Article not found</td></tr>";
		}
     	$data .= "</table>";
     	
     	$total_record = $i;
     	return $data;
	}


	private function viewAbstract_old($sql,$action="normal",&$total_record=0)	//$action = normal/search
	{
		$dbq = query ($sql);
		assert ($dbq);
		
		$i		= 0;
		$data 	= "";
		$colnum = 3;
		
		$data.= "<table border =0 width=50% cellspacing=0 cellpadding=10>";
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
				$authors = str_replace(",",", ",$records['authors']);
				$keywords = str_replace(",",", ",$records['keywords']);
	
				$DbContent = self::strip_word_html(html_entity_decode($records['title'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><a>');
				//$DbContent=$records['title'];
				/*$DbContent=htmlentities($DbContent,ENT_COMPAT,'utf-8'); 
	      		$DbContent = html_entity_decode($DbContent,ENT_COMPAT,'ISO-8859-1'); 
	      		$DbContent = self::unhtmlspecialchars($DbContent);*/
	      		
	      		$DbContent1 = self::strip_word_html(html_entity_decode($records['long_desc'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br><a>');
				//$DbContent=$records['title'];
				/*$DbContent1=htmlentities($DbContent1,ENT_COMPAT,'utf-8'); 
	      		$DbContent1 = html_entity_decode($DbContent1,ENT_COMPAT,'ISO-8859-1'); 
	      		$DbContent1 = self::unhtmlspecialchars($DbContent1);*/
				$i++;
				$data .= "<tr>";
				$data .= "<div id=\"txt\"><p>Home >";
				if ($records['issue_status']=='Current')
				{
					$data .= " <a href=\"current-issue.php\">Current Issue</a></p>";
				}
				else
				{
					$data .= " <a href=\"past-issue.php\">Past Issue</a></p>";
				}
				 
				 $data .= "<p>Journal of Applied Pharmaceutical Science ".$records['issue_no'].", ".$records['issue_period']."<br />";
				  if ($records['doi']!='')
				{
				$data .= "DOI: ".$records['doi']." <br />
				
				";
				
				}
				$data .= "ISSN 2231-3354</p>";
				if($records['cross_mark'] == 1){
				

				$data .= "<div style='float:right; margin:0px; '>
				<script type='text/javascript' src='https://ajax.googleapis.com/ajax/libs/jquery/1.4.4/jquery.min.js' ></script> 
					<script type='text/javascript' src='https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.7/jquery-ui.min.js' ></script> 
					<script src='https://crossmark-cdn.crossref.org/widget/v2.0/widget.js'></script>
				<a data-target='crossmark' ><img style='border: 0px; ' align = 'right'
				 id='crossmark-icon'  src='https://crossmark.crossref.org/images/crossmark_button.png' title='' alt=''></a>
				 </div>
				 <div style='clear:both;'></div>
				 <div id='crossmark-dialog' style='display: none;' title=''> 
						<!-- the external CrossMark data is loaded inside this iframe --> 
						<iframe id='crossmark-dialog-frame' frameborder='0'></iframe> 
					</div>";
					
			}
				  $data .= "<h3>".$records['article_category']."</h3><br />
				  <h2>".$DbContent."</h2>
				  <p><strong>".self::strip_word_html(html_entity_decode($authors,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br>')."</strong></p>
				  <p>[<a href=\"admin/php/uploads/".$records['file_url']."\" onclick=\"window.open('counter.php?did=".$records['article_id']."','_parent')\" target=\"_blank\">Download PDF</a>]</p>
				  
				  ";
                  
				  if (strlen($DbContent1) >1)
				  {
					  $data .= "<h4>Abstract</h4>
					  <p class=\"abstract\">".$DbContent1."</p>
					  <p><strong>Keywords:</strong> ".self::strip_word_html(html_entity_decode($keywords,ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><br>')."</p></br></br>";
				 /*  $data .= "<a rel='license' href='http://creativecommons.org/licenses/by-nc/4.0/'><img alt='Creative Commons Licence' style='border-width:0' src='https://i.creativecommons.org/l/by-nc/4.0/80x15.png' /></a><br/>This work is licensed under a <a rel='license' href='http://creativecommons.org/licenses/by-nc/4.0/'>Creative Commons Attribution-NonCommercial 4.0 International License</a>. Based on a work at <a href='http://www.japsonline.com' target='_blank' 
rel='dct:source'
xmlns:dct='http://purl.org/dc/terms/' class='view'>www.japsonline.com</a>. Permissions beyond the scope of this license may be available at <a href='http://www.japsonline.com' target='_blank' 
rel='cc:morePermissions'
xmlns:cc='http://creativecommons.org/ns#' class='view'>www.japsonline.com</a>."; */
$data .= "<p><strong>Copyright:&nbsp;</strong>Author(s). This is an open access article distributed under the terms of the&nbsp;<a href='http://creativecommons.org/licenses/by/4.0/' target='_blank' data-saferedirecturl='https://www.google.com/url?hl=en&amp;q=http://creativecommons.org/licenses/by/4.0/&amp;source=gmail&amp;ust=1532236209826000&amp;usg=AFQjCNEZx3D95Dd1qeLAy2d2fMKsCshf9A'>Creative Commons Attribution License</a>, which permits unrestricted use, distribution, and reproduction in any medium, provided the original author and source are credited.&nbsp; <img alt='Creative Commons Licence' style='border-width:0' src='https://i.creativecommons.org/l/by-nc/4.0/80x15.png' /></p>.";
				  }
			      $data .= "</div>";
				$data .="</tr>";
				
			}	
		}
		else
		{
			$data .= "<tr><td colspan=5 align=center>Article not found</td></tr>";
		}
     	$data .= "</table>";
     	
     	$total_record = $i;
     	return $data;
	}

	public function fillArticleCategory()
	{
		echo "<option value=\"\">Select Subject</option>";
		foreach($this->tabname as $key=>$value)
		{
			echo "<option value=\"$value\">$value</option>";
		}
	}
	public function fillArticlesIssue()
	{
			$sql="select issue_no,issue_id from issue_master";
		$dbq = query ($sql);
		assert ($dbq);
		echo "<option value=\"\">Select Issue</option>";
		echo "<option value=\"0\">All Issue</option>";
		while($records = fetch($dbq))
		{
			echo "<option value=".$records['issue_id'].">".$records['issue_no']."</option>";		
		}
	}
	
	public function searchArticleForm1()
	{
	?>	      <form name="frm">
               <table width="100%">
                    <tr>
					<td class="head" colspan="2">Search Article</td>
					</tr>
                    <tr>
					<td>Title:</td>	
					<td>Author:</td>
					</tr>
                    <tr>
					<td><input name="tit" type="text" size="20" height="15px" />
					</td>  						    
					<td><input name="au" type="text" size="20" height="15px" /></td>
					</tr>
					<tr>
					<td>Keywords:</td>
                    <td>Issue:</td>
                    </tr>
					<tr>
					<td>
					<input name="ky" type="text" size="20" height="15px" /></td>
                    <td><select name="isu" style="width:150px;"><?php $this->fillArticlesIssue(); ?>
                    </select></td>
					</tr>
						<tr>
						<td align="left"><input type="Submit" name="smt" value="Search" onclick="return submitform()" height="15px" /></td>
                        <td></td>
 	</table>
		</form>
                                  
                                  
		<?php 
	}
public function unhtmlspecialcharsReverse( $string )
	{
		$string = str_replace ( chr(157),  '&#65533;', $string ); //129
		$string = str_replace ( chr(128),  '&euro;', $string ); //129
	    $string = str_replace ( '�',  '&sbquo;', $string ); //130
	    $string = str_replace ( '�',   '&fnof;', $string ); //131
	    $string = str_replace ( '�',  '&bdquo;', $string ); //132
	    $string = str_replace ( '�',   '&hellip;', $string ); //133
	    $string = str_replace ( '�',   '&dagger;', $string ); //134
	    $string = str_replace ( '�',   '&Dagger;', $string ); //135
	    $string = str_replace ( '�',   '&circ;', $string ); //136 
	    $string = str_replace ( '�',   '&permil;', $string ); //137
	    $string = str_replace ( '�',   '&Scaron;', $string ); //138 
	    $string = str_replace ( '�',   '&lsaquo;', $string ); //139 
	    $string = str_replace ( '�',   '&OElig;', $string ); //140 
	    $string = str_replace ( '�',   '&#381;', $string ); //142  
	    $string = str_replace ( '�',   '&lsquo;', $string ); //145
	    $string = str_replace ( '�',   '&rsquo;', $string ); //146
	    $string = str_replace ( '�',   '&ldquo;', $string ); //147
	    $string = str_replace ( '�',   '&rdquo;', $string ); //148
	    $string = str_replace ( '�',   '&bull;', $string ); //149
	    $string = str_replace ( '�',   '&ndash;', $string ); //150
	    $string = str_replace ( '�',   '&mdash;', $string ); //151
	    $string = str_replace ( '� ',   '&tilde;', $string ); //152
	    $string = str_replace ( '�',   '&trade;', $string ); //153 
	    $string = str_replace ( '�',   '&scaron;', $string ); //154 
	    $string = str_replace ( '�',   '&rsaquo;', $string ); //155  
	    $string = str_replace ( '�',   '&oelig;', $string ); //156 
	    $string = str_replace ( '�',   '&#382;', $string ); //158 
	    $string = str_replace ( '�',   '&Yuml;', $string ); //159   
	    return $string;
	  }
	  
	  public function unhtmlspecialchars( $string )
	  {
	    //$string = str_replace ( '�',   '', $string );
	     $string = str_replace ( '�',chr(157) , $string ); //129
	    $string = str_replace ( '&euro;',  '�', $string ); //129
	    $string = str_replace ( '&sbquo;', '�', $string ); //130
	    $string = str_replace ( '&fnof;',  '�', $string ); //131
	    $string = str_replace ( '&bdquo;', '�', $string ); //132
	    $string = str_replace ( '&hellip;',  '�', $string ); //133
	    $string = str_replace ( '&dagger;',  '�', $string ); //134
	    $string = str_replace ( '&Dagger;',  '�', $string ); //135
	    $string = str_replace ( '&circ;',  '�', $string ); //136 
	    $string = str_replace ( '&permil;',  '�', $string ); //137
	    $string = str_replace ( '&Scaron;',  '�', $string ); //138 
	    $string = str_replace ( '&lsaquo;',  '�', $string ); //139 
	    $string = str_replace ( '&OElig;',  '�', $string ); //140 
	    $string = str_replace ( 'Ž',   '�', $string ); //142  
	    $string = str_replace ( '&lsquo;',  '�', $string ); //145
	    $string = str_replace ( '&rsquo;',  '�', $string ); //146
	    $string = str_replace ( '&ldquo;',  '�', $string ); //147
	    $string = str_replace ( '&rdquo;',  '�', $string ); //148
	    $string = str_replace ( '&bull;',  '�', $string ); //149
	    $string = str_replace ( '&ndash;',  '�', $string ); //150
	    $string = str_replace ( '&mdash;',  '�', $string ); //151
	    $string = str_replace ( '&tilde;',  '� ', $string ); //152
	    $string = str_replace ( '&trade;',  '�', $string ); //153 
	    $string = str_replace ( '&scaron;',  '�', $string ); //154 
	    $string = str_replace ( '&rsaquo;',  '�', $string ); //155  
	    $string = str_replace ( '&oelig;',  '�', $string ); //156 
	    $string = str_replace ( 'ž',   '�', $string ); //158 
	    $string = str_replace ( '&Yuml;',  '�', $string ); //159   
	    return $string;
	  }
	public function searchArticleForm()
	{
	
		?>	<form name="frm">
			<table width="100%">
				<tr><td colspan="3" class="head">Search Article</td>
				</tr>
								  <tr>
								     <td width="32%">Title:</td>
								     
								  <td colspan="2"><input name="tit" type="text" class="text"/></td>
								  </tr>
                                  <tr>
								    <td>Author:</td>
								    
								  <td colspan="2"><input name="au" type="text"  class="text"/></td>
								  </tr>
								  
								   <tr>
								     <td>Keywords:</td>
								     
								  <td colspan="2"><input name="ky" type="text" class="text"/></td>
								  </tr>
								   <tr>
								     <td>Issue:</td>
								     
								  <td valign="bottom" colspan="2"><select name="isu"  style="width:125px" class="text"><?php $this->fillArticlesIssue(); ?></select></td>
								  
							      </tr>	
                                  <tr>
								     <td>Subject:</td>
								     
								  <td width="4%" valign="bottom"><select name="cat" class="text"><?php $this->fillArticleCategory(); ?></select></td>
								  <td width="64%"><img src="images/ijlpr_24.jpg" alt="search" width="15" height="15" onclick="return submitform()"/></td>
							      </tr>							                                                                        
								  </table>
								  </form>
                                  
                                  
		<?php 
	}
	public function getUsersOnline() { 
	$count = 0; 
		$sessionpath=session_save_path();
		$handle = opendir($sessionpath); 
		if ($handle == false) return -1; 
		/*while (false !== ($file = readdir($handle))) {
			if (filectime($file)< (time()-60)) {  // 600 = 10*60
			 $count++; 
			}
		}*/
		while (($file = readdir($handle)) != false) { 
			//if (preg_match("/^sess", $file)){ 
			if (substr($file, 0,4) == "sess"){
			
			//echo time()- filemtime( $sessionpath.'/'.$file)."<br>";
//			echo time()- filemtime( $sessionpath.'/'.$file);
				if(time()- filemtime( $sessionpath.'/'.$file) <  1900) { 
				echo time()- filemtime( $sessionpath.'/'.$file)." ";
						$count++; 
					}else{
						unlink($sessionpath.'/'.$file);
					}	
			}
		} 
		closedir($handle); 
		//echo $count; 
		return $count; 
} 
public function updateCounter2($id)
	{
	    $dated  = date("Y-m-d");
		//$month = date('m'); 
		 $month=date("m");
		$year = date('Y'); 
		 $sql = "select * from ViewDownload where Article_id= $id and MONTH(dated) = '$month' and YEAR(dated) = '$year'";
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;	
		if( getRowCount($dbq) >=1  )
		{
			while($records = fetch($dbq))
			{ 
				//$count=$records['View']+1;
				$dated=strtotime($records['dated']);
				
				$monthName=date("m");
				$yearname=date("Y");
				$count=$records['View']+1;
				//if($monthName==$month && $yearname==$year){
				
				 $sql1="update ViewDownload set View=".$count." where Article_id=".$id." and MONTH(dated)=".$monthName. " and YEAR(dated)=".$yearname;
				query ($sql1);
				break;
				//}
			}
		}else{
			$sql22 = "insert into ViewDownload(Article_id,Dated,View) values($id,'$dated',1)";
			query ($sql22);
		}
		 /////Done by Pratibha for viewed counter update/////
		/* $sql1 = "select view from articles where article_id=".$id;
		$dbq1 = query ($sql1);
		assert ($dbq1);
		$i1=1;	
		if( getRowCount($dbq1) >=1)
		{
			while($records1 = fetch($dbq1))
			{ 
				$count1=$records1['view']+1;
				$sql2="update articles set view=".$count1." where article_id=".$id;
				query ($sql2);
				break;
			}
		} */
	}
	
	public function updateDownloadCounter1($id)
	{
	    $dated  = date("Y-m-d");
		$month = date('m'); 
		$year = date('Y'); 
		$sql = "select * from ViewDownload where Article_id= $id and MONTH(dated) = '$month' and YEAR(dated) = '$year'";
		$dbq = query ($sql);
		assert ($dbq);
		$i=1;	
		if( getRowCount($dbq) >=1)
		{
			while($records = fetch($dbq))
			{ 
				$count=$records['Download']+1;
				$sql1="update ViewDownload set Download=".$count." where Article_id=".$id." and MONTH(dated)=".$month. " and YEAR(dated)=".$year;
				query ($sql1);
				break;
			}
		}else{
			$sql22 = "insert into ViewDownload(Article_id,Dated,Download) values($id,'$dated',1)";
			query ($sql22);
		}
		//////Made by pratibha for download count//////
		/* $sql1 = "select download from articles where article_id=".$id;
		$dbq1 = query ($sql1);
		assert ($dbq1);
		$i1=1;	
		if( getRowCount($dbq1) >=1)
		{
			while($records1 = fetch($dbq1))
			{ 
				$count1=$records1['download']+1;
				$sql2="update articles set download=".$count1." where article_id=".$id;
				query ($sql2);
				break;
			}
		} */
		
	}
	public function getNextArticle($aid)
	{
		$aid+=1;
		$sql = "SELECT * FROM articles WHERE article_id>=$aid ORDER BY article_id LIMIT 1";
		$dbq = query ($sql);
		assert ($dbq);
		if( getRowCount($dbq) >=1)
		{
		$records = fetch($dbq);
		if($records['issue_id'] == 0){
				echo '<li><a href="abstract1.php?article_id='.$records['article_id'].'"><img src="images/preva.png" border="0" align="absmiddle" style="margin-right:5px;" width="18" /> Next article</a></li>';
	   }else{
				echo '<li><a href="abstract.php?article_id='.$records['article_id'].'"><img src="images/preva.png" border="0" align="absmiddle" style="margin-right:5px;" width="18" /> Next article</a></li>';
			}
			
		}
		else
		{
			echo '<li><img src="images/preva.png" border="0" align="absmiddle" style="margin-right:5px;" width="18" /> Next article</li>';
		}
		//return $issue_url;
	}
	
	public function getPrevArticle($aid)
	{
		$aid-=1;
		$sql = "SELECT * FROM articles WHERE article_id<=$aid ORDER BY article_id DESC LIMIT 1";
		$dbq = query ($sql);
		assert ($dbq);
		if( getRowCount($dbq) >=1)
		{
			$records = fetch($dbq);
			if($records['issue_id'] == 0){
				echo '<li><a href="abstract1.php?article_id='.$records['article_id'].'"><img src="images/back.png" border="0" align="absmiddle" style="margin-right:5px;" width="18" /> Previous article</a></li>';
			}else{
				echo '<li><a href="abstract.php?article_id='.$records['article_id'].'"><img src="images/back.png" border="0" align="absmiddle" style="margin-right:5px;" width="18" /> Previous article</a></li>';
			}
			
		}
		else
		{
			echo '<li><img src="images/back.png" border="0" align="absmiddle" style="margin-right:5px;" width="18" />Previous article</li>';
		}
		//return $issue_url;
	}
	
		public function getAuthors(){
		$cat1_total = 0;
		$article_id	= isset ($_REQUEST['article_id']) ? $_REQUEST['article_id'] : '';
						
		$sql = "SELECT * FROM articles a join issue_master i where a.issue_id=i.issue_id and article_id = $article_id order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		//$sql = "SELECT * FROM articles a join issue_master i where a.issue_id=i.issue_id and $condition order by article_id $desc LIMIT 1";
		
		$dbq = query ($sql);
		assert ($dbq);
		
		$authors="";
		
		
		if( getRowCount($dbq) >=1)
		{			
			while($records = fetch($dbq))
			{ 
				$authors = $records['authors'];
			}
		}
		return $authors;	
		
	}
	public function getAuthorsonline(){
		$cat1_total = 0;
		$article_id	= isset ($_REQUEST['article_id']) ? $_REQUEST['article_id'] : '';
						
		$sql = "SELECT * FROM articles  where  article_id = $article_id order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		//$sql = "SELECT * FROM articles a join issue_master i where a.issue_id=i.issue_id and $condition order by article_id $desc LIMIT 1";
		
		$dbq = query ($sql);
		assert ($dbq);
		
		$authors="";
		
		
		if( getRowCount($dbq) >=1)
		{			
			while($records = fetch($dbq))
			{ 
				$authors = $records['authors'];
			}
		}
		return $authors;	
		
	}
	public function googleadsence()
	{
		echo '
		<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
		<script>
			  (adsbygoogle = window.adsbygoogle || []).push({
				google_ad_client: "ca-pub-7087960426313598",
				enable_page_level_ads: true
			  });
		</script>';
	}
	
	public function dynamicheader()
	{
		 $users = getUsersOnline();
		/* if($users<10)
		{
			$users=10;
		} */
		if($users<=0)
		{
			//$users = 1;
		}
	  ?>
	
	     <ul>
		<li><a href="index.php">Home</a></li>
		<li><a href="about-japs.php">About the Journal</a></li>
		<li><a href="japs-editorial-board.php">Editorial Board</a></li>
		<li><a href="authors-guidelines.php">Author's Guidelines</a></li>
		<li><a href="submit-manuscript.php">Submit Manuscript</a></li>
		<li><a href="contact-japs.php">Contact</a></li>
		<li style="color:#FFFFFF"></li>
		<li style="color:#FFFFFF; padding-left:200px;"><?php echo "Users Online: " . $users; ?>
		</li>
		</ul>
	<?php	
	}
	
	
	public function dynamicfooter()
	{
	  ?>
	
		<div style="width:969px; margin:auto;">
		
		<p style="font-size:12px;">&copy;  2019 Open Science Publishers LLP, unless otherwise stated.</br>
By using this website, you agree to our <a style="font-size:12px;" href="termsconditions.php">Terms and Conditions</a>, <a style="font-size:12px;" href="termsconditions.php">Privacy statement</a> and <a style="font-size:12px;" href="termsconditions.php">Cookies </a>policy. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="http://www.hitwebcounter.com/" target="_blank">
			<img src="http://hitwebcounter.com/counter/counter.php?page=4824968&style=0006&nbdigits=6&type=page&initCount=0" title="" Alt=""   border="0" >
			</a></p></br>
		 <!-- <img src="https://assets.crossref.org/logo/crossref-similarity-check-logo-200.svg" width="120" height="98" alt="Crossref Similarity Check logo" align="right" style="margin-left:2px">
		<div style="text-align:center;">
		<right>
			<!-- hitwebcounter Code START -->
			<!--<a href="http://www.hitwebcounter.com/" target="_blank">
			<img src="http://hitwebcounter.com/counter/counter.php?page=4824968&style=0006&nbdigits=6&type=page&initCount=0" title="" Alt=""   border="0" >
			</a>
		   </right>
       </div>-->
      

		<p>
		<!--<a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/3.0/deed.en_US"><img alt="Creative Commons License" style="border-width:0" src="http://i.creativecommons.org/l/by-nc-sa/3.0/80x15.png" /></a><!--<span xmlns:dct="http://purl.org/dc/terms/" href="http://purl.org/dc/dcmitype/Text" property="dct:title" rel="dct:type"> Journal of Applied Biology & Biotechnology </span> by <a xmlns:cc="http://creativecommons.org/ns#" href="http://jabonline.in/" property="cc:attributionName" rel="cc:attributionURL">Open Science Publishers LLP</a> is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/3.0/deed.en_US">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Based on a work at <a xmlns:dct="http://purl.org/dc/terms/" href="http://jabonline.in/" rel="dct:source">http://jabonline.in/</a>.</p>-->


</div>
	<?php	
	}
	
	
	
	public function get_articles($author){
		
		$cat1_total = 0;
		//$author1 =  rtrim($author," ");
		//$author=strip_tags (substr($author,0,(strLen($author)-3)));
		//$author = preg_replace('/\s+/', '', $author);$allowed_tags = '<b><i><sup><sub><em><strong><u><br><p> <a><ul><ol><li><br>
		//$author = strip_tags ( string $author [, string $allowable_tags ] );
		
		$author = preg_replace("/<sup>(.*?)<\/sup>/i","",$author);
		$author = 	strip_tags($author);
		$author = 	trim($author);
		//$author = substr($author,0,-2);
		//$sql = "select a.*,a.file_url as filelink,b.issue_no from onlinefirst a, issue_master b where a.issue_id = b.issue_id and b.issue_status='Current' order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";'%$author_name%'
	   $sql = "select * from articles where authors LIKE '%".$author."%' ";
		
		//echo $sql = "select * from articles where authors LIKE '%$author%'"; 
		// 0 for online first articles
		$cat1_data = $this->makeDataGrid1($sql,"normal",$cat1_total,0);
		?>
	
	   <?php
        	echo $cat1_data;
	    		?>
				<?php
				if($cat1_total<=0 )
				{
				?>		<div class="head" style="height:150px" align="center"+><br/><br/><br/>No data available. </div>
<?php 
				}

	}
	public function get_articles_keywords($author,$keyword){
		
		$cat1_total = 0;
		$author = preg_replace("/<sup>(.*?)<\/sup>/i","",$author);
		$author = 	strip_tags($author);
		$author = 	trim($author);
	   $sql = "select * from articles where authors LIKE '%".$author."%' and keywords LIKE  '%".$keyword."%'";
		$cat1_data = $this->makeDataGrid1($sql,"normal",$cat1_total,0);
		?>
	   <?php
        	echo $cat1_data;
	    		?>
				<?php
				if($cat1_total<=0 && $cat2_total<=0)
				{
				?>		<div class="head" style="height:150px" align="center"+><br/><br/><br/>No data available. </div>
<?php 
				}

	}

	private function makeDataGrid1($sql,$action="normal",&$total_record=0, $mv=0)	//$action = normal/search
	{
		$dbq = query ($sql);
		assert ($dbq);
		
		$i		= 0;
		$data 	= "";
		$colnum = 3;
		
		$data.= "<table border =\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"10\" style='font-size: 12px; line-height: 18px;'>";
		if( getRowCount($dbq) >=1)
		{
			$data .= "<tr style=\"background: #fff;border-top: 1px solid #ccc;\"></tr>";
			while($records = fetch($dbq))
			{   
				$authors = stripslashes(str_replace(",",", ",$records['authors']));
	
				$i++;
				
				$data .= "<tr>";
				
				
				// $DbContent = self::strip_word_html(html_entity_decode($records['title'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><ul><ol><li><br>');
				
				$DbContent = self::strip_word_html(html_entity_decode($records['title'],ENT_COMPAT, "UTF-8"), $allowed_tags = '<b><i><sup><sub><em><strong><u><ul><ol><li><br>');
				
				//$DbContent = html_entity_decode($records['title']);
				
				
				
				//$DbContent=$records['title'];
				//$DbContent=htmlentities($DbContent,ENT_COMPAT,'utf-8'); 
	      		//$DbContent = html_entity_decode($DbContent,ENT_COMPAT,'ISO-8859-1'); 
	      		//$DbContent = self::unhtmlspecialchars($DbContent);
	      		
				//$DbContent12 = strip_tags($authors);
				
				$DbContent12 = html_entity_decode($authors);
			    $DbContent1y = preg_replace("/<sup>(.*?)<\/sup>/i","",$DbContent12);
				$DbContent1 = strip_tags($DbContent1y);
				
				
				
				//$DbContent=$records['title'];
				//$DbContent1=htmlentities($DbContent1,ENT_COMPAT,'utf-8'); 
	      		//$DbContent1 = html_entity_decode($DbContent1,ENT_COMPAT,'ISO-8859-1'); 
	      		//$DbContent1 = self::unhtmlspecialchars($DbContent1);
	      		
				$data .= "<td colspan=\"2\"><span class=\"title\"><strong>".$records['article_category'].": </strong>" .$DbContent. "</span><p class=\"author\" style=\"margin:0; padding:2px 0;\"> ".$DbContent1." </p><p style=\"margin:0; padding:2px 0;\">";
        if($records['doi']!='')
	  	{
			 if ($records['doiurl']!='')
				 {
				  if(strstr($records['doiurl'],'http://'))
				  {
				   $data .= "<strong>DOI:</strong>: "."<a href=".$records['doiurl']." target =\" \">".$records['doi']."</a>&nbsp;&nbsp;&nbsp;&nbsp;";      
				  }else
				  {
				  $data .= "<strong>DOI:</strong> "."<a href=http://".$records['doiurl']." target =\" \">".$records['doi']."</a>&nbsp;&nbsp;&nbsp;&nbsp;";
				  }
				 }else
				 {
				  $data .= "<strong>DOI:</strong> ".$records['doi']."&nbsp;&nbsp;&nbsp;&nbsp;";

				 }
				
		} 
	  	else 
	  	{
	  		//$data .= "<p style=\"margin:0; padding:2px 0;\">Pages: ".$records['pages']."</p>";
	  	}
		if($records['issue_id']==0){
		$data .= "<i>Published Online : ".date('M d, Y', strtotime($records['publish_date']))."</i></p>";
		}
			$data .="</td></tr><tr>";
		if($mv)
		{
			$data .= "<td>[<a href=\"javascript:void(0);\" onclick=\"window.open('counter.php?aid=".$records['article_id']."','_self')\" >Abstract</a>]&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  [<a href=\"admin/php/uploads/".$records['filelink']."\" onclick=\"window.open('counter.php?did=".$records['article_id']."','_parent')\" target=\"_blank\">Full Text PDF</a>] </td>";
			$data .= "<td style=\"text-align:right;\"><i>Viewed:&nbsp;&nbsp;".$records['view']."</i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <i>Downloaded:&nbsp;&nbsp;".$records['download']."</i></td>";
			
			
		}
		else {
			$data .= "<td><p style=\"margin:0; padding:2px 0;\">[<a href=\"javascript:void(0);\" onclick=\"window.open('counter.php?aid=".$records['article_id']."','_self')\">Abstract</a>]";
			
			if($records['file_url'] != ""){
           $data .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  [<a href=\"admin/php/uploads/".$records['file_url']."\" onclick=\"window.open('counter.php?did=".$records['article_id']."','_parent')\" target=\"_blank\">Full Text PDF</a>]";
			}
			// &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			
			// [<a href=\"downloadxml.php?article_id=".$records['article_id']."\"> XML: Abstract + References </a>]</p></td>";		
		}
      			$data .="</tr>";
				$data .= "<tr style=\"background: #fff;border-top: 1px solid #ccc;\"></tr><td colspan=\"2\" height='10'></td><tr><td colspan=\"4\"><hr></td></tr>";				
			}	
		}
		else
		{
			$data .= "";			
		}		
     	$data .= "</table>";     	
     	$total_record = $i;
     	return $data;
		
	}
	public function getissuenamefromid($id)
	{     
     	
		//$article_id	= isset ($_REQUEST['article_id']) ? $_REQUEST['article_id'] : '';		
		$sql = "SELECT issue_no FROM issue_master where issue_id = $id";
		//$sql = "SELECT * FROM articles a join issue_master i where a.issue_id=i.issue_id and $condition order by article_id $desc LIMIT 1";
		$dbq = query ($sql);
		assert ($dbq);
		
		$authors="";
		
		
		if( getRowCount($dbq) >=1)
		{			
			while($records = fetch($dbq))
			{ 
				$authors = $records['issue_no'];
			}
		}
		return $authors;					


	}
	function getIssueNo($issueid)
	{
		$issue_no = "";
		$sql = "select issue_no from issue_master where issue_id=$issueid";
		$dbq = query ($sql);
		assert ($dbq);
		if( getRowCount($dbq) >=1)
		{
			$records = fetch($dbq);
			$issue_no = trim($records['issue_no']);
		}
		return $issue_no;
	}
	public function insertjabrecord($email)
	{
		$sts =false;
		$date= date("Y-m-d H:i:s");
		$sql = "select * from subscribe_master where email_id='$email'";
		$dbq = query ($sql);
		if(getRowCount($dbq)==0)
		{
			$sql = "insert into subscribe_master (email_id,sub_date) values('$email','$date')";
			$dbq = query ($sql);
			$sts =true;
		}else{
			$sts =false;
		}
	   return $sts;
	}
	public function onlinefirstArticle()
	{
		
		$cat1_total = 0;
		$sql = "select a.*,a.file_url as filelink,b.issue_no from onlinefirst a, issue_master b where a.issue_id = b.issue_id and b.issue_status='Current' order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		$sql = "select * from articles where issue_id = 0"; // 0 for online first articles
		$cat1_data = $this->makeDataGrid1($sql,"normal",$cat1_total,0);
		?>
	
	   <?php
        	echo $cat1_data;
	    		?>
				<?php
				if($cat1_total<=0 && $cat2_total<=0)
				{
				?>		<div class="head" style="height:150px" align="center"><br /><br /><br />No data available. </div>
<?php 
				}
	}	
	public function getrightcontent()
	{
	echo '<div id="right" class="imp"><div id="current" style="backgraund-color:white;">
	<h1>CURRENT ISSUE</h1><p> <a href="current-issue.php">';
	self::getCurrentIssuePeriod();
	echo'</a></p>
	<br/>
	<hr/>
	<h1>ARCHIVES</h1>
	<p> <a href="past-issue.php">READ MORE</a></p>
	</div><!--end articles-->
	<!--<div id="download" align="center"><a href="copyright.pdf"><img src="images/download.jpg" width="170" height="54" border="0" /></a>
	</div>--><!--end download-->
	<div id="social"><p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Follow us<a href="https://www.facebook.com/JournalOfAppliedPharmaceuticalScience" target="_blank"><img src="images/facebook.png" width="26" height="26" border="0"  align="absmiddle" style="margin-left:5px;"/></a><a href="https://twitter.com/#!/Editor_JAPS" target="_blank"><img src="images/twitter.png" width="26" height="26" border="0"  align="absmiddle" style="margin-left:5px;"/></a></p>>
	</div><!--end download-->
	</div>
	  <table><td height="5"></td></table>
	 <center>
	  <img  src="images/open-access.jpg" /></center>';
	}
	
	
	public function abstractdetailsonline()
	{     
     	$cat1_total = 0;
		$article_id	= isset ($_REQUEST['article_id']) ? $_REQUEST['article_id'] : '';
						
		$sql = "SELECT * FROM articles  where  article_id = $article_id order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		//$sql = "SELECT * FROM articles a join issue_master i where a.issue_id=i.issue_id and $condition order by article_id $desc LIMIT 1";
		$cat1_data = $this->viewAbstract($sql,"normal",$cat1_total);
				echo $cat1_data;					
		?>
<?php
	} 
	
		public function get_Keyword_articles($keyword){
		
		$cat1_total = 0;
		//$sql = "select a.*,a.file_url as filelink,b.issue_no from onlinefirst a, issue_master b where a.issue_id = b.issue_id and b.issue_status='Current' order by  cast(trim(SUBSTRING_INDEX(pages,'-',1)) as unsigned)";
		$sql = "select * from articles where keywords LIKE '%".$keyword."%'"; // 0 for online first articles
		$cat1_data = $this->makeDataGrid1($sql,"normal",$cat1_total,0);
		?>
	
	   <?php
        	echo $cat1_data;
	    		?>
				<?php
				if($cat1_total<=0 && $cat2_total<=0)
				{
				?>		<div class="head" style="height:150px" align="center"><br /><br /><br />No data available. </div>
<?php 
				}

	}
	
} 
//////////////////////////////////////////////////

/*	public function currentIssueArticle()
	{
		$cat1_total = 0;
		$cat2_total = 0;
		
		//echo $sql = "select a.*,replace(a.file_url,'[URL]',b.issue_url) as filelink from articles a, issue_master b where a.issue_id = b.issue_id and b.issue_status='Current' and article_category='" . $this->tabname[0] . "'";
		$sql = "select a.*,a.file_url as filelink from articles a, issue_master b where a.issue_id = b.issue_id and b.issue_status='Current' and a.article_category='" . $this->tabname[0] . "'";
		$cat1_data = $this->makeDataGrid($sql,"current",$cat1_total);
		
		$sql = "select a.*,a.file_url as filelink from articles a, issue_master b where a.issue_id = b.issue_id and b.issue_status='Current' and article_category='" . $this->tabname[1] . "'";
		$cat2_data = $this->makeDataGrid($sql,"current",$cat2_total);	 		
		
		?>
		<!-- background-color:#F5F7F0; -->
		<div id="tabs" style="background-color:#F5F7F0;border:0;">
	    	<ul>
	    		<?php
	    			if ($cat1_total >=1)
	    			{
	    				?>
	    					<li><a href="#Pha"><span><?php  echo $this->tabname[0]; ?></span></a></li>		
	    				<?php 
	    			}
	    			
					if ($cat2_total >=1)
	    			{
	    				?>
	    					<li><a href="#Bio"><span><?php  echo $this->tabname[1]; ?></span></a></li>		
	    				<?php 
	    			}
	    		?>
	    	</ul>
	    	<?php 
	    		if ($cat1_total >=1)
	    		{
	    			?><div id="Pha" style="background-color:#F5F7F0;"><?php  echo $cat1_data; ?></div><?php 
	    		}
	    		
				if ($cat2_total >=1)
	    		{
	    			?><div id="Bio" style="background-color:#F5F7F0;"><?php  echo $cat2_data; ?></div><?php 
	    		}
	    	?>
		</div>
		<?php 
	}
